/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

@ExtendWith(value={MockitoExtension.class})
class RemoveVisitTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    RemoveVisitTest() {
    }

    @Test
    void remove_last_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        PlanningVisit removedVisit = RemoveVisitTest.visit(1L);
        PlanningVisit otherVisit = RemoveVisitTest.visit(2L);
        solution.getVisitList().add(otherVisit);
        solution.getVisitList().add(removedVisit);
        otherVisit.setPreviousStandstill((Standstill)RemoveVisitTest.visit(10L));
        otherVisit.setNextVisit(removedVisit);
        removedVisit.setPreviousStandstill((Standstill)otherVisit);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVisit)).thenReturn((Object)removedVisit);
        RemoveVisit removeVisit = new RemoveVisit(removedVisit);
        removeVisit.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeEntityRemoved(ArgumentMatchers.any(PlanningVisit.class));
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterEntityRemoved(ArgumentMatchers.any(PlanningVisit.class));
        Assertions.assertThat((List)solution.getVisitList()).containsExactly((Object[])new PlanningVisit[]{otherVisit});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void remove_middle_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        PlanningVisit firstVisit = RemoveVisitTest.visit(1L);
        PlanningVisit removedVisit = RemoveVisitTest.visit(2L);
        PlanningVisit lastVisit = RemoveVisitTest.visit(3L);
        solution.getVisitList().add(firstVisit);
        solution.getVisitList().add(lastVisit);
        solution.getVisitList().add(removedVisit);
        firstVisit.setPreviousStandstill((Standstill)PlanningVehicleFactory.testVehicle((long)1L));
        firstVisit.setNextVisit(removedVisit);
        removedVisit.setPreviousStandstill((Standstill)firstVisit);
        removedVisit.setNextVisit(lastVisit);
        lastVisit.setPreviousStandstill((Standstill)removedVisit);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVisit)).thenReturn((Object)removedVisit);
        RemoveVisit removeVisit = new RemoveVisit(removedVisit);
        removeVisit.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged(ArgumentMatchers.any(PlanningVisit.class), ArgumentMatchers.anyString());
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged(ArgumentMatchers.any(PlanningVisit.class), ArgumentMatchers.anyString());
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeEntityRemoved(ArgumentMatchers.any(PlanningVisit.class));
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterEntityRemoved(ArgumentMatchers.any(PlanningVisit.class));
        ((ListAssert)Assertions.assertThat((List)solution.getVisitList()).hasSize(2)).containsOnly((Object[])new PlanningVisit[]{firstVisit, lastVisit});
        Assertions.assertThat((Object)lastVisit.getPreviousStandstill()).isEqualTo((Object)firstVisit);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_solution_visit_list_does_not_contain_working_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        long removedId = 111L;
        PlanningVisit removedVisit = RemoveVisitTest.visit(removedId);
        long wrongId = 222L;
        PlanningVisit wrongVisit = RemoveVisitTest.visit(wrongId);
        wrongVisit.setPreviousStandstill((Standstill)RemoveVisitTest.visit(10L));
        solution.getVisitList().add(wrongVisit);
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVisit)).thenReturn((Object)removedVisit);
        RemoveVisit removeVisit = new RemoveVisit(removedVisit);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> removeVisit.doChange(this.scoreDirector)).withMessageMatching(".*List .*" + wrongId + ".* doesn't contain the working.*" + removedId + ".*");
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)SolutionFactory.emptySolution());
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new RemoveVisit(RemoveVisitTest.visit(0L)).doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }

    private static PlanningVisit visit(long id) {
        return PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)id));
    }
}

