/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;

class PlanningLocationFactoryTest {
    PlanningLocationFactoryTest() {
    }

    @Test
    void planning_location_should_have_same_properties_as_domain_location() {
        long id = 344L;
        double latitude = -20.5;
        double longitude = 11.7;
        long distance = 11234L;
        Location location = new Location(id, Coordinates.valueOf((double)latitude, (double)longitude));
        PlanningLocation planningLocation = PlanningLocationFactory.fromDomain((Location)location, otherLocation -> distance);
        Assertions.assertThat((long)planningLocation.getId()).isEqualTo(id);
        PlanningLocation other = PlanningLocationFactory.testLocation((long)(id + 1L));
        Assertions.assertThat((long)planningLocation.getDistanceTo(other)).isEqualTo(distance);
        Assertions.assertThat((double)planningLocation.getAngle(other)).isNotZero();
    }

    @Test
    void test_locations_distance_map_should_work() {
        long distance = 11231L;
        PlanningLocation planningLocation = PlanningLocationFactory.testLocation((long)0L, location -> distance);
        Assertions.assertThat((long)planningLocation.getDistanceTo(PlanningLocationFactory.testLocation((long)1L))).isEqualTo(distance);
    }

    @Test
    void test_location_without_distance_map_should_throw_exception() {
        PlanningLocation planningLocation = PlanningLocationFactory.testLocation((long)0L);
        PlanningLocation otherLocation = PlanningLocationFactory.testLocation((long)1L);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> planningLocation.getDistanceTo(otherLocation));
    }
}

