/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.planner.DistanceMapImpl;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;

class PlanningLocationTest {
    PlanningLocationTest() {
    }

    @Test
    void distance_to_location_should_equal_value_in_distance_map() {
        HashMap<Long, Distance> distanceMap = new HashMap<Long, Distance>();
        long otherId = 321L;
        long millis = 777777L;
        distanceMap.put(otherId, Distance.ofMillis((long)millis));
        Location domainLocation = new Location(1L, Coordinates.valueOf((double)0.0, (double)0.0));
        PlanningLocation planningLocation = new PlanningLocation(domainLocation.id(), domainLocation.coordinates().latitude().doubleValue(), domainLocation.coordinates().longitude().doubleValue(), (DistanceMap)new DistanceMapImpl(distanceMap::get));
        Assertions.assertThat((long)planningLocation.getDistanceTo(PlanningLocationFactory.testLocation((long)otherId))).isEqualTo(millis);
    }

    @Test
    void angle_from_depot_at_zero_should_be_atan2_of_latitude_longitude() {
        PlanningLocation center = PlanningLocationTest.fromCoordinates(0.0, 0.0);
        Assertions.assertThat((double)center.getAngle(PlanningLocationTest.fromCoordinates(0.0, 1.0))).isZero();
        Assertions.assertThat((double)center.getAngle(PlanningLocationTest.fromCoordinates(0.0, -1.0))).isEqualTo(Math.PI);
        Assertions.assertThat((double)center.getAngle(PlanningLocationTest.fromCoordinates(1.0, 0.0))).isEqualTo(1.5707963267948966);
        Assertions.assertThat((double)center.getAngle(PlanningLocationTest.fromCoordinates(-1.0, 0.0))).isEqualTo(-1.5707963267948966);
        Assertions.assertThat((double)center.getAngle(PlanningLocationTest.fromCoordinates(-4.9E-324, -1.0))).isEqualTo(-Math.PI);
        Assertions.assertThat((double)center.getAngle(PlanningLocationTest.fromCoordinates(0.0, 1.0))).isZero();
    }

    @Test
    void angle_from_depot_on_real_coordinates_should_be_atan2_of_latitude_longitude() {
        PlanningLocation depot = PlanningLocationTest.fromCoordinates(1.77, -10.5);
        Offset offset = Assertions.offset((Double)0.05);
        Assertions.assertThat((double)depot.getAngle(PlanningLocationTest.fromCoordinates(1.76, -5.0))).isCloseTo(0.0, offset).isNegative();
        Assertions.assertThat((double)depot.getAngle(PlanningLocationTest.fromCoordinates(100000.0, -1.0))).isCloseTo(1.5707963267948966, offset);
    }

    private static PlanningLocation fromCoordinates(double latitude, double longitude) {
        return new PlanningLocation(0L, latitude, longitude, location -> 0L);
    }
}

