/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.Objects;

public class Distance {
    public static final Distance ZERO = Distance.ofMillis(0L);
    private final long millis;

    public static Distance ofMillis(long millis) {
        return new Distance(millis);
    }

    private Distance(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Milliseconds (" + millis + ") must not be negative.");
        }
        this.millis = millis;
    }

    public long millis() {
        return this.millis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Distance distance = (Distance)o;
        return this.millis == distance.millis;
    }

    public int hashCode() {
        return Objects.hash(this.millis);
    }

    public String toString() {
        return String.format("%dh %dm %ds %dms", this.millis / 3600000L, this.millis / 60000L % 60L, this.millis / 1000L % 60L, this.millis % 1000L);
    }
}

