/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.math.BigDecimal;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

@Entity
class LocationEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(precision=9, scale=7)
    private BigDecimal latitude;
    @Column(precision=10, scale=7)
    private BigDecimal longitude;
    private String description;

    private LocationEntity() {
    }

    LocationEntity(BigDecimal latitude, BigDecimal longitude, String description) {
        this.latitude = Objects.requireNonNull(latitude);
        this.longitude = Objects.requireNonNull(longitude);
        this.description = Objects.requireNonNull(description);
    }

    long getId() {
        return this.id;
    }

    BigDecimal getLatitude() {
        return this.latitude;
    }

    BigDecimal getLongitude() {
        return this.longitude;
    }

    String getDescription() {
        return this.description;
    }

    public String toString() {
        return "LocationEntity{id=" + this.id + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", description='" + this.description + '\'' + '}';
    }
}

