/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import java.util.Objects;
import org.optaweb.vehiclerouting.plugin.planner.domain.AbstractPlanningObject;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;

public class PlanningLocation
extends AbstractPlanningObject {
    private final double latitude;
    private final double longitude;
    private final DistanceMap travelDistanceMap;

    PlanningLocation(long id, double latitude, double longitude, DistanceMap travelDistanceMap) {
        super(id);
        this.latitude = latitude;
        this.longitude = longitude;
        this.travelDistanceMap = Objects.requireNonNull(travelDistanceMap);
    }

    public long getDistanceTo(PlanningLocation location) {
        if (this == location) {
            return 0L;
        }
        return this.travelDistanceMap.distanceTo(location);
    }

    public double getAngle(PlanningLocation location) {
        double latitudeDifference = location.latitude - this.latitude;
        double longitudeDifference = location.longitude - this.longitude;
        return Math.atan2(latitudeDifference, longitudeDifference);
    }

    public String toString() {
        return "PlanningLocation{latitude=" + this.latitude + ",longitude=" + this.longitude + ",travelDistanceMap=" + this.travelDistanceMap + ",id=" + this.id + '}';
    }
}

