/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaweb.vehiclerouting.plugin.planner.domain.AbstractPlanningObject;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.weight.DepotAngleVisitDifficultyWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=DepotAngleVisitDifficultyWeightFactory.class)
public class PlanningVisit
extends AbstractPlanningObject
implements Standstill {
    private PlanningLocation location;
    private int demand;
    @PlanningVariable(valueRangeProviderRefs={"vehicleRange", "visitRange"}, graphType=PlanningVariableGraphType.CHAINED)
    private Standstill previousStandstill;
    private PlanningVisit nextVisit;
    @AnchorShadowVariable(sourceVariableName="previousStandstill")
    private PlanningVehicle vehicle;

    @Override
    public PlanningLocation getLocation() {
        return this.location;
    }

    public void setLocation(PlanningLocation location) {
        this.location = location;
    }

    public int getDemand() {
        return this.demand;
    }

    public void setDemand(int demand) {
        this.demand = demand;
    }

    public Standstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(Standstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    @Override
    public PlanningVisit getNextVisit() {
        return this.nextVisit;
    }

    @Override
    public void setNextVisit(PlanningVisit nextVisit) {
        this.nextVisit = nextVisit;
    }

    @Override
    public PlanningVehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(PlanningVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public long getDistanceFromPreviousStandstill() {
        if (this.previousStandstill == null) {
            throw new IllegalStateException("This method must not be called when the previousStandstill (" + this.previousStandstill + ") is not initialized yet.");
        }
        return this.getDistanceFrom(this.previousStandstill);
    }

    public long getDistanceFrom(Standstill standstill) {
        return standstill.getLocation().getDistanceTo(this.location);
    }

    public long getDistanceTo(Standstill standstill) {
        return this.location.getDistanceTo(standstill.getLocation());
    }

    public String toString() {
        return "PlanningVisit{" + (this.location == null ? "" : "location=" + this.location.getId()) + ",demand=" + this.demand + (this.previousStandstill == null ? "" : ",previousStandstill='" + this.previousStandstill.getLocation().getId()) + (this.nextVisit == null ? "" : ",nextVisit=" + this.nextVisit.getId()) + (this.vehicle == null ? "" : ",vehicle=" + this.vehicle.getId()) + ",id=" + this.id + '}';
    }
}

