/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.plugin.websocket.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.websocket.PortableLocation;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoutingPlan;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoutingPlanFactory;
import org.optaweb.vehiclerouting.plugin.websocket.RoutingProblemInfo;
import org.optaweb.vehiclerouting.plugin.websocket.ServerInfo;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.RegionService;
import org.optaweb.vehiclerouting.service.route.RouteListener;
import org.optaweb.vehiclerouting.service.vehicle.VehicleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.DestinationVariable;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.simp.annotation.SubscribeMapping;
import org.springframework.stereotype.Controller;

@Controller
class WebSocketController {
    private final RouteListener routeListener;
    private final RegionService regionService;
    private final LocationService locationService;
    private final VehicleService vehicleService;
    private final DemoService demoService;

    @Autowired
    WebSocketController(RouteListener routeListener, RegionService regionService, LocationService locationService, VehicleService vehicleService, DemoService demoService) {
        this.routeListener = routeListener;
        this.regionService = regionService;
        this.locationService = locationService;
        this.vehicleService = vehicleService;
        this.demoService = demoService;
    }

    @SubscribeMapping(value={"/serverInfo"})
    ServerInfo subscribeToServerInfoTopic() {
        BoundingBox boundingBox = this.regionService.boundingBox();
        List<PortableCoordinates> portableBoundingBox = Arrays.asList(PortableCoordinates.fromCoordinates((Coordinates)boundingBox.getSouthWest()), PortableCoordinates.fromCoordinates((Coordinates)boundingBox.getNorthEast()));
        List demos = this.demoService.demos().stream().map(routingProblem -> new RoutingProblemInfo(routingProblem.name(), routingProblem.visits().size())).collect(Collectors.toList());
        return new ServerInfo(portableBoundingBox, this.regionService.countryCodes(), demos);
    }

    @SubscribeMapping(value={"/route"})
    PortableRoutingPlan subscribeToRouteTopic() {
        RoutingPlan routingPlan = this.routeListener.getBestRoutingPlan();
        return PortableRoutingPlanFactory.fromRoutingPlan((RoutingPlan)routingPlan);
    }

    @MessageMapping(value={"/location"})
    void addLocation(PortableLocation request) {
        this.locationService.createLocation(new Coordinates(request.getLatitude(), request.getLongitude()), request.getDescription());
    }

    @MessageMapping(value={"/location/{id}/delete"})
    void removeLocation(@DestinationVariable long id) {
        this.locationService.removeLocation(id);
    }

    @MessageMapping(value={"/demo/{name}"})
    void demo(@DestinationVariable String name) {
        this.demoService.loadDemo(name);
    }

    @MessageMapping(value={"/clear"})
    void clear() {
        this.locationService.removeAll();
        this.vehicleService.removeAll();
    }

    @MessageMapping(value={"vehicle"})
    void addVehicle() {
        this.vehicleService.createVehicle();
    }

    @MessageMapping(value={"/vehicle/{id}/delete"})
    void removeVehicle(@DestinationVariable long id) {
        this.vehicleService.removeVehicle(id);
    }

    @MessageMapping(value={"/vehicle/deleteAny"})
    void removeAnyVehicle() {
        this.vehicleService.removeAnyVehicle();
    }

    @MessageMapping(value={"/vehicle/{id}/capacity"})
    void changeCapacity(@DestinationVariable long id, int capacity) {
        this.vehicleService.changeCapacity(id, capacity);
    }
}

