/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.LocationCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.LocationEntity;
import org.optaweb.vehiclerouting.plugin.persistence.LocationRepositoryImpl;

@ExtendWith(value={MockitoExtension.class})
class LocationRepositoryImplTest {
    @Mock
    private LocationCrudRepository crudRepository;
    @InjectMocks
    private LocationRepositoryImpl repository;
    @Captor
    private ArgumentCaptor<LocationEntity> locationEntityCaptor;

    LocationRepositoryImplTest() {
    }

    private Location testLocation() {
        long id = 76L;
        BigDecimal latitude = BigDecimal.valueOf(1.2);
        BigDecimal longitude = BigDecimal.valueOf(3.4);
        String description = "description";
        return new Location(76L, new Coordinates(latitude, longitude), "description");
    }

    LocationEntity mockLocationEntity(Location location) {
        LocationEntity locationEntity = (LocationEntity)Mockito.mock(LocationEntity.class);
        Mockito.when((Object)locationEntity.getId()).thenReturn((Object)location.id());
        Mockito.when((Object)locationEntity.getLatitude()).thenReturn((Object)location.coordinates().latitude());
        Mockito.when((Object)locationEntity.getLongitude()).thenReturn((Object)location.coordinates().longitude());
        Mockito.when((Object)locationEntity.getDescription()).thenReturn((Object)location.description());
        return locationEntity;
    }

    @Test
    void should_create_location_and_generate_id() {
        LocationEntity locationEntity = this.mockLocationEntity(this.testLocation());
        Mockito.when((Object)this.crudRepository.save(this.locationEntityCaptor.capture())).thenReturn((Object)locationEntity);
        Coordinates savedCoordinates = Coordinates.valueOf((double)0.00213, (double)32.777);
        String savedDescription = "new location";
        Location createdLocation = this.repository.createLocation(savedCoordinates, savedDescription);
        LocationEntity savedLocation = (LocationEntity)this.locationEntityCaptor.getValue();
        Assertions.assertThat((BigDecimal)savedLocation.getLatitude()).isEqualTo((Object)savedCoordinates.latitude());
        Assertions.assertThat((BigDecimal)savedLocation.getLongitude()).isEqualTo((Object)savedCoordinates.longitude());
        Assertions.assertThat((String)savedLocation.getDescription()).isEqualTo(savedDescription);
        Assertions.assertThat((long)createdLocation.id()).isEqualTo(locationEntity.getId());
        Assertions.assertThat((Object)createdLocation.coordinates()).isEqualTo((Object)new Coordinates(locationEntity.getLatitude(), locationEntity.getLongitude()));
        Assertions.assertThat((String)createdLocation.description()).isEqualTo(locationEntity.getDescription());
    }

    @Test
    void remove_created_location_by_id() {
        Location testLocation = this.testLocation();
        LocationEntity locationEntity = this.mockLocationEntity(testLocation);
        long id = testLocation.id();
        Mockito.when((Object)this.crudRepository.findById((Object)id)).thenReturn(Optional.of(locationEntity));
        Location removed = this.repository.removeLocation(id);
        Assertions.assertThat((Object)removed).isEqualTo((Object)testLocation);
        ((LocationCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteById((Object)id);
    }

    @Test
    void removing_nonexistent_location_should_fail() {
        Mockito.when((Object)this.crudRepository.findById((Object)ArgumentMatchers.anyLong())).thenReturn(Optional.empty());
        int uniqueNonexistentId = 7173;
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.removeLocation((long)uniqueNonexistentId)).withMessageContaining(String.valueOf(uniqueNonexistentId));
    }

    @Test
    void remove_all_locations() {
        this.repository.removeAll();
        ((LocationCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteAll();
    }

    @Test
    void get_all_locations() {
        Location testLocation = this.testLocation();
        LocationEntity locationEntity = this.mockLocationEntity(testLocation);
        Mockito.when((Object)this.crudRepository.findAll()).thenReturn(Collections.singletonList(locationEntity));
        Assertions.assertThat((List)this.repository.locations()).containsExactly((Object[])new Location[]{testLocation});
    }

    @Test
    void find_by_id() {
        Location testLocation = this.testLocation();
        LocationEntity locationEntity = this.mockLocationEntity(testLocation);
        Mockito.when((Object)this.crudRepository.findById((Object)testLocation.id())).thenReturn(Optional.of(locationEntity));
        Assertions.assertThat((Optional)this.repository.find(testLocation.id())).contains((Object)testLocation);
    }
}

