/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleEntity;
import org.optaweb.vehiclerouting.plugin.persistence.VehicleRepositoryImpl;

@ExtendWith(value={MockitoExtension.class})
class VehicleRepositoryImplTest {
    @Mock
    private VehicleCrudRepository crudRepository;
    @InjectMocks
    private VehicleRepositoryImpl repository;
    @Captor
    private ArgumentCaptor<VehicleEntity> vehicleEntityCaptor;

    VehicleRepositoryImplTest() {
    }

    private Vehicle testVehicle() {
        long id = 19L;
        String name = "vehicle name";
        int capacity = 1100;
        return VehicleFactory.createVehicle((long)id, (String)name, (int)capacity);
    }

    VehicleEntity mockVehicleEntity(Vehicle vehicle) {
        VehicleEntity vehicleEntity = (VehicleEntity)Mockito.mock(VehicleEntity.class);
        Mockito.when((Object)vehicleEntity.getId()).thenReturn((Object)vehicle.id());
        Mockito.when((Object)vehicleEntity.getName()).thenReturn((Object)vehicle.name());
        Mockito.when((Object)vehicleEntity.getCapacity()).thenReturn((Object)vehicle.capacity());
        return vehicleEntity;
    }

    @Test
    void should_create_vehicle_and_generate_id_and_name() {
        VehicleEntity savedEntity = this.mockVehicleEntity(this.testVehicle());
        Mockito.when((Object)this.crudRepository.save(this.vehicleEntityCaptor.capture())).thenReturn((Object)savedEntity);
        int savedCapacity = 1;
        Vehicle createdVehicle = this.repository.createVehicle(savedCapacity);
        List savedVehicles = this.vehicleEntityCaptor.getAllValues();
        Assertions.assertThat((List)savedVehicles).hasSize(2);
        Assertions.assertThat((String)((VehicleEntity)savedVehicles.get(0)).getName()).isNull();
        Assertions.assertThat((int)((VehicleEntity)savedVehicles.get(0)).getCapacity()).isEqualTo(savedCapacity);
        Assertions.assertThat((String)((VehicleEntity)savedVehicles.get(1)).getName()).isEqualTo("Vehicle " + savedEntity.getId());
        Assertions.assertThat((int)((VehicleEntity)savedVehicles.get(1)).getCapacity()).isEqualTo(savedCapacity);
        Assertions.assertThat((long)createdVehicle.id()).isEqualTo(savedEntity.getId());
        Assertions.assertThat((String)createdVehicle.name()).isEqualTo(savedEntity.getName());
        Assertions.assertThat((int)createdVehicle.capacity()).isEqualTo(savedEntity.getCapacity());
    }

    @Test
    void create_vehicle_from_given_data() {
        VehicleEntity savedEntity = this.mockVehicleEntity(this.testVehicle());
        Mockito.when((Object)this.crudRepository.save(this.vehicleEntityCaptor.capture())).thenReturn((Object)savedEntity);
        boolean savedCapacity = true;
        VehicleData vehicleData = VehicleFactory.vehicleData((String)"x", (int)1);
        Vehicle createdVehicle = this.repository.createVehicle(vehicleData);
        VehicleEntity savedVehicle = (VehicleEntity)this.vehicleEntityCaptor.getValue();
        Assertions.assertThat((String)savedVehicle.getName()).isEqualTo(vehicleData.name());
        Assertions.assertThat((int)savedVehicle.getCapacity()).isEqualTo(vehicleData.capacity());
        Assertions.assertThat((long)createdVehicle.id()).isEqualTo(savedEntity.getId());
        Assertions.assertThat((String)createdVehicle.name()).isEqualTo(savedEntity.getName());
        Assertions.assertThat((int)createdVehicle.capacity()).isEqualTo(savedEntity.getCapacity());
    }

    @Test
    void remove_created_location_by_id() {
        Vehicle testVehicle = this.testVehicle();
        VehicleEntity locationEntity = this.mockVehicleEntity(testVehicle);
        long id = testVehicle.id();
        Mockito.when((Object)this.crudRepository.findById((Object)id)).thenReturn(Optional.of(locationEntity));
        Vehicle removed = this.repository.removeVehicle(id);
        Assertions.assertThat((Object)removed).isEqualTo((Object)testVehicle);
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteById((Object)id);
    }

    @Test
    void removing_nonexistent_vehicle_should_fail() {
        Mockito.when((Object)this.crudRepository.findById((Object)ArgumentMatchers.anyLong())).thenReturn(Optional.empty());
        int uniqueNonexistentId = 7173;
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> this.repository.removeVehicle((long)uniqueNonexistentId)).withMessageContaining(String.valueOf(uniqueNonexistentId));
    }

    @Test
    void remove_all_vehicles() {
        this.repository.removeAll();
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).deleteAll();
    }

    @Test
    void get_all_vehicles() {
        Vehicle testVehicle = this.testVehicle();
        VehicleEntity locationEntity = this.mockVehicleEntity(testVehicle);
        Mockito.when((Object)this.crudRepository.findAll()).thenReturn(Collections.singletonList(locationEntity));
        Assertions.assertThat((List)this.repository.vehicles()).containsExactly((Object[])new Vehicle[]{testVehicle});
    }

    @Test
    void find_by_id() {
        Vehicle testVehicle = this.testVehicle();
        VehicleEntity vehicleEntity = this.mockVehicleEntity(testVehicle);
        Mockito.when((Object)this.crudRepository.findById((Object)testVehicle.id())).thenReturn(Optional.of(vehicleEntity));
        Assertions.assertThat((Optional)this.repository.find(testVehicle.id())).contains((Object)testVehicle);
    }

    @Test
    void update() {
        Vehicle testVehicle = this.testVehicle();
        this.repository.update(testVehicle);
        ((VehicleCrudRepository)Mockito.verify((Object)this.crudRepository)).save(this.vehicleEntityCaptor.capture());
        VehicleEntity savedVehicle = (VehicleEntity)this.vehicleEntityCaptor.getValue();
        Assertions.assertThat((long)savedVehicle.getId()).isEqualTo(testVehicle.id());
        Assertions.assertThat((String)savedVehicle.getName()).isEqualTo(testVehicle.name());
        Assertions.assertThat((int)savedVehicle.getCapacity()).isEqualTo(testVehicle.capacity());
    }
}

