/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.Optional;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceEntity;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceKey;
import org.optaweb.vehiclerouting.service.distance.DistanceRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class DistanceRepositoryImpl
implements DistanceRepository {
    private final DistanceCrudRepository distanceRepository;

    @Autowired
    DistanceRepositoryImpl(DistanceCrudRepository distanceRepository) {
        this.distanceRepository = distanceRepository;
    }

    @Override
    public void saveDistance(Location from, Location to, long distance) {
        DistanceEntity distanceEntity = new DistanceEntity(new DistanceKey(from.id(), to.id()), distance);
        this.distanceRepository.save(distanceEntity);
    }

    @Override
    public long getDistance(Location from, Location to) {
        Optional optional = this.distanceRepository.findById(new DistanceKey(from.id(), to.id()));
        if (optional.isPresent()) {
            return ((DistanceEntity)optional.get()).getDistance();
        }
        return -1L;
    }
}

