/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
class DataSetDownloadController {
    private final DemoService demoService;

    DataSetDownloadController(DemoService demoService) {
        this.demoService = demoService;
    }

    @GetMapping(value={"/dataset/export"})
    @ResponseBody
    public ResponseEntity<Resource> exportDataSet() throws IOException {
        String dataSet = this.demoService.exportDataSet();
        byte[] dataSetBytes = dataSet.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream is = new ByteArrayInputStream(dataSetBytes);){
            HttpHeaders headers = new HttpHeaders();
            ContentDisposition attachment = ContentDisposition.builder((String)"attachment").filename("vrp_data_set.yaml").creationDate(ZonedDateTime.now()).size(Long.valueOf(dataSetBytes.length)).build();
            headers.setContentDisposition(attachment);
            ResponseEntity responseEntity = ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).contentLength((long)dataSetBytes.length).contentType(new MediaType("text", "x-yaml", StandardCharsets.UTF_8)).body((Object)new InputStreamResource((InputStream)is));
            return responseEntity;
        }
    }
}

