/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.persistence;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceCrudRepository;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceEntity;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceKey;
import org.optaweb.vehiclerouting.plugin.persistence.DistanceRepositoryImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.orm.jpa.DataJpaTest;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@DataJpaTest
@ExtendWith(value={SpringExtension.class})
class DistanceRepositoryIntegrationTest {
    @Autowired
    private DistanceCrudRepository crudRepository;
    private DistanceRepositoryImpl repository;

    DistanceRepositoryIntegrationTest() {
    }

    @BeforeEach
    void setUp() {
        this.repository = new DistanceRepositoryImpl(this.crudRepository);
    }

    @Test
    void crudRepository() {
        DistanceKey key = new DistanceKey(1L, 2L);
        DistanceEntity entity = new DistanceEntity(key, Long.valueOf(730107L));
        DistanceEntity savedEntity = (DistanceEntity)this.crudRepository.save((Object)entity);
        Assertions.assertThat((Object)savedEntity).isEqualTo((Object)entity);
        Assertions.assertThat((long)this.crudRepository.count()).isOne();
        Assertions.assertThat((Optional)this.crudRepository.findById((Object)key)).get().isEqualTo((Object)entity);
        this.crudRepository.deleteById((Object)key);
        Assertions.assertThat((long)this.crudRepository.count()).isZero();
    }

    @Test
    void should_return_saved_distance() {
        Location location1 = new Location(1L, Coordinates.valueOf((double)7.0, (double)-4.0));
        Location location2 = new Location(2L, Coordinates.valueOf((double)5.0, (double)9.0));
        long distance = 956766417L;
        this.repository.saveDistance(location1, location2, distance);
        Assertions.assertThat((long)this.repository.getDistance(location1, location2)).isEqualTo(distance);
    }

    @Test
    void should_return_negative_number_when_distance_not_found() {
        Location location1 = new Location(1L, Coordinates.valueOf((double)7.0, (double)-4.0));
        Location location2 = new Location(2L, Coordinates.valueOf((double)5.0, (double)9.0));
        Assertions.assertThat((long)this.repository.getDistance(location1, location2)).isNegative();
    }
}

