/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.distance;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.distance.DistanceMatrixImpl;
import org.optaweb.vehiclerouting.service.distance.DistanceRepository;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;

@ExtendWith(value={MockitoExtension.class})
class DistanceMatrixImplTest {
    @Mock
    private DistanceCalculator distanceCalculator;
    @Mock
    private DistanceRepository distanceRepository;
    @InjectMocks
    private DistanceMatrixImpl distanceMatrix;

    DistanceMatrixImplTest() {
    }

    @Test
    void should_calculate_distance_map() {
        Mockito.when((Object)this.distanceRepository.getDistance((Location)ArgumentMatchers.any(), (Location)ArgumentMatchers.any())).thenReturn((Object)-1L);
        DistanceMatrixImpl distanceMatrix = new DistanceMatrixImpl((DistanceCalculator)new MockDistanceCalculator(), this.distanceRepository);
        Location l0 = DistanceMatrixImplTest.location(100L, 0);
        Location l1 = DistanceMatrixImplTest.location(111L, 1);
        Location l9neg = DistanceMatrixImplTest.location(321L, -9);
        DistanceMatrixRow matrixRow0 = distanceMatrix.addLocation(l0);
        Assertions.assertThat((Object)matrixRow0.distanceTo(l0.id())).isEqualTo((Object)Distance.ZERO);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> matrixRow0.distanceTo(l1.id()));
        DistanceMatrixRow matrixRow1 = distanceMatrix.addLocation(l1);
        Assertions.assertThat((Object)matrixRow1.distanceTo(l1.id())).isEqualTo((Object)Distance.ZERO);
        Assertions.assertThat((Object)matrixRow1.distanceTo(l0.id())).isEqualTo((Object)Distance.ofMillis((long)1L));
        Assertions.assertThat((Object)matrixRow0.distanceTo(l1.id())).isEqualTo((Object)Distance.ofMillis((long)1L));
        DistanceMatrixRow matrixRow9 = distanceMatrix.addLocation(l9neg);
        Assertions.assertThat((Object)matrixRow9.distanceTo(l0.id())).isEqualTo((Object)Distance.ofMillis((long)9L));
        Assertions.assertThat((Object)matrixRow9.distanceTo(l1.id())).isEqualTo((Object)Distance.ofMillis((long)10L));
        Assertions.assertThat((Object)matrixRow0.distanceTo(l9neg.id())).isEqualTo((Object)Distance.ofMillis((long)9L));
        Assertions.assertThat((Object)matrixRow1.distanceTo(l9neg.id())).isEqualTo((Object)Distance.ofMillis((long)10L));
        distanceMatrix.clear();
        Location l500 = DistanceMatrixImplTest.location(500L, 500);
        DistanceMatrixRow matrixRow500 = distanceMatrix.addLocation(l500);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> matrixRow500.distanceTo(l0.id()));
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> matrixRow9.distanceTo(l500.id()));
    }

    @Test
    void should_call_router_and_persist_distances_when_repo_is_empty() {
        Location l1 = DistanceMatrixImplTest.location(100L, -1);
        Location l2 = DistanceMatrixImplTest.location(111L, 20);
        long dist12 = 12L;
        long dist21 = 21L;
        Mockito.when((Object)this.distanceRepository.getDistance((Location)ArgumentMatchers.any(), (Location)ArgumentMatchers.any())).thenReturn((Object)-1L);
        Mockito.when((Object)this.distanceCalculator.travelTimeMillis(l1.coordinates(), l2.coordinates())).thenReturn((Object)dist12);
        Mockito.when((Object)this.distanceCalculator.travelTimeMillis(l2.coordinates(), l1.coordinates())).thenReturn((Object)dist21);
        this.distanceMatrix.addLocation(l1);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceCalculator});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceRepository});
        this.distanceMatrix.addLocation(l2);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).getDistance(l2, l1);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).getDistance(l1, l2);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).saveDistance(l2, l1, dist21);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).saveDistance(l1, l2, dist12);
    }

    @Test
    void should_not_call_router_when_repo_is_full() {
        Location l1 = DistanceMatrixImplTest.location(1L, 0);
        Location l2 = DistanceMatrixImplTest.location(2L, 0);
        Mockito.when((Object)this.distanceRepository.getDistance(l1, l2)).thenReturn((Object)0L);
        Mockito.when((Object)this.distanceRepository.getDistance(l2, l1)).thenReturn((Object)1L);
        this.distanceMatrix.addLocation(l1);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceCalculator});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceRepository});
        this.distanceMatrix.addLocation(l2);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).getDistance(l2, l1);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository)).getDistance(l1, l2);
        ((DistanceRepository)Mockito.verify((Object)this.distanceRepository, (VerificationMode)Mockito.never())).saveDistance((Location)ArgumentMatchers.any(Location.class), (Location)ArgumentMatchers.any(Location.class), ArgumentMatchers.anyLong());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.distanceCalculator});
    }

    private static Location location(long id, int longitude) {
        return new Location(id, new Coordinates(BigDecimal.ZERO, BigDecimal.valueOf(longitude)));
    }

    private static class MockDistanceCalculator
    implements DistanceCalculator {
        private MockDistanceCalculator() {
        }

        public long travelTimeMillis(Coordinates from, Coordinates to) {
            return (long)Math.abs(to.longitude().doubleValue() - from.longitude().doubleValue());
        }
    }
}

