/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.RouteOptimizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class LocationService {
    private static final Logger logger = LoggerFactory.getLogger(LocationService.class);
    private final LocationRepository repository;
    private final RouteOptimizer optimizer;
    private final DistanceMatrix distanceMatrix;
    private final ApplicationEventPublisher eventPublisher;

    @Autowired
    LocationService(LocationRepository repository, RouteOptimizer optimizer, DistanceMatrix distanceMatrix, ApplicationEventPublisher eventPublisher) {
        this.repository = repository;
        this.optimizer = optimizer;
        this.distanceMatrix = distanceMatrix;
        this.eventPublisher = eventPublisher;
    }

    public synchronized boolean createLocation(Coordinates coordinates, String description) {
        Objects.requireNonNull(coordinates);
        Objects.requireNonNull(description);
        return this.submitToPlanner(this.repository.createLocation(coordinates, description));
    }

    public synchronized boolean addLocation(Location location) {
        return this.submitToPlanner(Objects.requireNonNull(location));
    }

    private boolean submitToPlanner(Location location) {
        try {
            DistanceMatrixRow distanceMatrixRow = this.distanceMatrix.addLocation(location);
            this.optimizer.addLocation(location, distanceMatrixRow);
        }
        catch (Exception e) {
            logger.error("Failed to calculate distances for {}, it will be discarded", (Object)location, (Object)e);
            this.eventPublisher.publishEvent((ApplicationEvent)new ErrorEvent((Object)this, "Failed to calculate distances for " + location + ", it will be discarded.\n" + e.toString()));
            this.repository.removeLocation(location.id());
            return false;
        }
        return true;
    }

    public synchronized void removeLocation(long id) {
        Location depot;
        Optional optionalLocation = this.repository.find(id);
        if (!optionalLocation.isPresent()) {
            this.eventPublisher.publishEvent((ApplicationEvent)new ErrorEvent((Object)this, "Location [" + id + "] cannot be removed because it doesn't exist."));
            return;
        }
        Location removedLocation = (Location)optionalLocation.get();
        List locations = this.repository.locations();
        if (locations.size() > 1 && removedLocation.equals((Object)(depot = locations.stream().min(Comparator.comparingLong(Location::id)).orElseThrow(() -> new IllegalStateException("Impossible. Locations have size (" + locations.size() + ") but the stream is empty."))))) {
            this.eventPublisher.publishEvent((ApplicationEvent)new ErrorEvent((Object)this, "You can only remove depot if there are no visits."));
            return;
        }
        this.optimizer.removeLocation(removedLocation);
        this.repository.removeLocation(id);
        this.distanceMatrix.removeLocation(removedLocation);
    }

    public synchronized void removeAll() {
        this.optimizer.removeAllLocations();
        this.repository.removeAll();
        this.distanceMatrix.clear();
    }
}

