/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.plugin.planner.DistanceMapImpl;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;

class DistanceMapImplTest {
    DistanceMapImplTest() {
    }

    @Test
    void matrix_row_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new DistanceMapImpl(null));
    }

    @Test
    void distance_map_should_return_value_from_distance_matrix_row() {
        PlanningLocation location2 = PlanningLocationFactory.testLocation((long)2L);
        Distance distance = Distance.ofMillis((long)45000L);
        DistanceMatrixRow matrixRow = locationId -> distance;
        DistanceMapImpl distanceMap = new DistanceMapImpl(matrixRow);
        Assertions.assertThat((long)distanceMap.distanceTo(location2)).isEqualTo(distance.millis());
    }
}

