/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.plugin.websocket.PortableErrorMessage;
import org.optaweb.vehiclerouting.service.error.ErrorMessage;
import org.springframework.boot.test.json.JacksonTester;
import org.springframework.boot.test.json.JsonContentAssert;

class PortableErrorMessageTest {
    private JacksonTester<PortableErrorMessage> json;

    PortableErrorMessageTest() {
    }

    @BeforeEach
    void setUp() {
        JacksonTester.initFields((Object)this, (ObjectMapper)new ObjectMapper());
    }

    @Test
    void marshal_to_json() throws IOException {
        String id = "c670dd37-62fb-4e86-95ed-c1f4953aaeaa";
        String text = "Error message.\nDetails.";
        PortableErrorMessage portableErrorMessage = PortableErrorMessage.fromMessage((ErrorMessage)ErrorMessage.of((String)id, (String)text));
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)this.json.write((Object)portableErrorMessage))).isStrictlyEqualToJson((CharSequence)"portable-error-message.json");
    }

    @Test
    void factory_method() {
        String id = "id";
        String text = "error";
        PortableErrorMessage portableErrorMessage = PortableErrorMessage.fromMessage((ErrorMessage)ErrorMessage.of((String)id, (String)text));
        Assertions.assertThat((String)portableErrorMessage.getId()).isEqualTo(id);
        Assertions.assertThat((String)portableErrorMessage.getText()).isEqualTo(text);
    }

    @Test
    void equals_hashCode_toString() {
        String id = "1";
        String text = "error message";
        ErrorMessage message = ErrorMessage.of((String)id, (String)text);
        PortableErrorMessage portableErrorMessage = PortableErrorMessage.fromMessage((ErrorMessage)message);
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)portableErrorMessage).isNotEqualTo(null)).isNotEqualTo((Object)new PortableErrorMessage("", text))).isNotEqualTo((Object)new PortableErrorMessage(id, ""))).isNotEqualTo((Object)message)).isEqualTo((Object)portableErrorMessage)).isEqualTo((Object)new PortableErrorMessage(id, text))).hasSameHashCodeAs((Object)new PortableErrorMessage(id, text))).asString().contains(new CharSequence[]{id, text});
    }
}

