/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.api.solver.Solver;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.util.concurrent.ListenableFutureTask;

@ExtendWith(value={MockitoExtension.class})
class SolverExceptionTest {
    @Mock
    private Solver<VehicleRoutingSolution> solver;
    @Mock
    private AsyncListenableTaskExecutor executor;
    @Mock
    private ApplicationEventPublisher eventPublisher;
    @InjectMocks
    private SolverManager solverManager;

    SolverExceptionTest() {
    }

    @Test
    void should_publish_error_if_solver_stops_solving_without_being_terminated() {
        ListenableFutureTask task = new ListenableFutureTask(SolutionFactory::emptySolution);
        Mockito.when((Object)this.executor.submitListenable((Callable)ArgumentMatchers.any(SolverManager.SolvingTask.class))).thenReturn((Object)task);
        task.run();
        this.solverManager.startSolver(SolutionFactory.emptySolution());
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)ArgumentMatchers.any(ErrorEvent.class));
    }

    @Test
    void should_not_publish_error_if_solver_is_terminated_early() {
        ListenableFutureTask task = new ListenableFutureTask(SolutionFactory::emptySolution);
        Mockito.when((Object)this.executor.submitListenable((Callable)ArgumentMatchers.any(SolverManager.SolvingTask.class))).thenReturn((Object)task);
        Mockito.when((Object)this.solver.isTerminateEarly()).thenReturn((Object)true);
        this.solverManager.startSolver(SolutionFactory.emptySolution());
        task.run();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.eventPublisher});
    }

    @Test
    void should_propagate_any_exception_from_solver() {
        ListenableFutureTask task = new ListenableFutureTask(() -> {
            throw new TestException();
        });
        Mockito.when((Object)this.executor.submitListenable((Callable)ArgumentMatchers.any(SolverManager.SolvingTask.class))).thenReturn((Object)task);
        task.run();
        this.solverManager.startSolver(SolutionFactory.emptySolution());
        ((ApplicationEventPublisher)Mockito.verify((Object)this.eventPublisher)).publishEvent((ApplicationEvent)ArgumentMatchers.any(ErrorEvent.class));
        PlanningVisit planningVisit = PlanningVisitFactory.testVisit((long)1L);
        PlanningVehicle planningVehicle = PlanningVehicleFactory.testVehicle((long)1L);
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.solverManager.addVisit(planningVisit));
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.solverManager.removeVisit(planningVisit));
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.solverManager.addVehicle(planningVehicle));
        SolverExceptionTest.assertTestExceptionThrownDuringOperation(() -> this.solverManager.removeVehicle(planningVehicle));
        SolverExceptionTest.assertTestExceptionThrownWhenStoppingSolver(this.solverManager);
    }

    private static void assertTestExceptionThrownDuringOperation(ThrowableAssert.ThrowingCallable runnable) {
        SolverExceptionTest.assertTestExceptionThrownDuring(runnable, "died");
    }

    private static void assertTestExceptionThrownWhenStoppingSolver(SolverManager routeOptimizer) {
        SolverExceptionTest.assertTestExceptionThrownDuring(() -> ((SolverManager)routeOptimizer).stopSolver(), "stop");
    }

    private static void assertTestExceptionThrownDuring(ThrowableAssert.ThrowingCallable runnable, String message) {
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(runnable).withMessageContaining(message).withCauseInstanceOf(TestException.class);
    }

    private static class TestException
    extends RuntimeException {
        private TestException() {
        }
    }
}

