/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

@ExtendWith(value={MockitoExtension.class})
class RemoveVehicleTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    RemoveVehicleTest() {
    }

    @Test
    void remove_vehicle() {
        PlanningVehicle removedVehicle = PlanningVehicleFactory.testVehicle((long)1L);
        PlanningVehicle otherVehicle = PlanningVehicleFactory.testVehicle((long)2L);
        PlanningDepot depot = new PlanningDepot(PlanningLocationFactory.testLocation((long)1L));
        PlanningVisit firstVisit = PlanningVisitFactory.testVisit((long)1L);
        PlanningVisit lastVisit = PlanningVisitFactory.testVisit((long)2L);
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Arrays.asList(removedVehicle, otherVehicle), (PlanningDepot)depot, Arrays.asList(firstVisit, lastVisit));
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVehicle)).thenReturn((Object)removedVehicle);
        removedVehicle.setNextVisit(firstVisit);
        firstVisit.setPreviousStandstill((Standstill)removedVehicle);
        firstVisit.setVehicle(removedVehicle);
        firstVisit.setNextVisit(lastVisit);
        lastVisit.setPreviousStandstill((Standstill)firstVisit);
        lastVisit.setVehicle(removedVehicle);
        RemoveVehicle removeVehicle = new RemoveVehicle(removedVehicle);
        removeVehicle.doChange(this.scoreDirector);
        Assertions.assertThat((Object)firstVisit.getPreviousStandstill()).isNull();
        Assertions.assertThat((Object)lastVisit.getPreviousStandstill()).isNull();
        Assertions.assertThat((List)solution.getVehicleList()).containsExactly((Object[])new PlanningVehicle[]{otherVehicle});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged((Object)firstVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged((Object)firstVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged((Object)lastVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged((Object)lastVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemFactRemoved((Object)removedVehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemFactRemoved((Object)removedVehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_solution_vehicle_list_does_not_contain_working_vehicle() {
        long removedId = 111L;
        long wrongId = 222L;
        PlanningVehicle removedVehicle = PlanningVehicleFactory.testVehicle((long)removedId);
        PlanningVehicle wrongVehicle = PlanningVehicleFactory.testVehicle((long)wrongId);
        PlanningDepot depot = new PlanningDepot(PlanningLocationFactory.testLocation((long)1L));
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Arrays.asList(wrongVehicle), (PlanningDepot)depot, Collections.emptyList());
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVehicle)).thenReturn((Object)removedVehicle);
        RemoveVehicle removeVehicle = new RemoveVehicle(removedVehicle);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> removeVehicle.doChange(this.scoreDirector)).withMessageMatching(".*List .*" + wrongId + ".* doesn't contain the working.*" + removedId + ".*");
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)SolutionFactory.emptySolution());
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new RemoveVehicle(PlanningVehicleFactory.testVehicle((long)1L)).doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }
}

