/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculationException;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.Region;
import org.optaweb.vehiclerouting.service.route.Router;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="app.routing", name={"engine"}, havingValue="graphhopper", matchIfMissing=true)
class GraphHopperRouter
implements Router,
DistanceCalculator,
Region {
    private final GraphHopperOSM graphHopper;

    @Autowired
    GraphHopperRouter(GraphHopperOSM graphHopper) {
        this.graphHopper = graphHopper;
    }

    @Override
    public List<Coordinates> getPath(Coordinates from, Coordinates to) {
        GHRequest ghRequest = new GHRequest(from.latitude().doubleValue(), from.longitude().doubleValue(), to.latitude().doubleValue(), to.longitude().doubleValue());
        PointList points = this.graphHopper.route(ghRequest).getBest().getPoints();
        return StreamSupport.stream(points.spliterator(), false).map(ghPoint3D -> Coordinates.valueOf(ghPoint3D.lat, ghPoint3D.lon)).collect(Collectors.toList());
    }

    @Override
    public long travelTimeMillis(Coordinates from, Coordinates to) {
        GHRequest ghRequest = new GHRequest(from.latitude().doubleValue(), from.longitude().doubleValue(), to.latitude().doubleValue(), to.longitude().doubleValue());
        GHResponse ghResponse = this.graphHopper.route(ghRequest);
        if (ghResponse.hasErrors()) {
            throw new DistanceCalculationException("No route", (Throwable)ghResponse.getErrors().get(0));
        }
        return ghResponse.getBest().getTime();
    }

    @Override
    public BoundingBox getBounds() {
        BBox bounds = this.graphHopper.getGraphHopperStorage().getBounds();
        return new BoundingBox(Coordinates.valueOf(bounds.minLat, bounds.minLon), Coordinates.valueOf(bounds.maxLat, bounds.maxLon));
    }
}

