/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo.dataset;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.domain.VehicleData;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSet;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetLocation;
import org.optaweb.vehiclerouting.service.demo.dataset.DataSetVehicle;
import org.springframework.stereotype.Component;

@Component
public class DataSetMarshaller {
    private final ObjectMapper mapper;

    DataSetMarshaller() {
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    }

    DataSetMarshaller(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public RoutingProblem unmarshal(Reader reader) {
        return DataSetMarshaller.toDomain(this.unmarshalToDataSet(reader));
    }

    public String marshal(RoutingProblem routingProblem) {
        return this.marshal(DataSetMarshaller.toDataSet(routingProblem));
    }

    DataSet unmarshalToDataSet(Reader reader) {
        try {
            return (DataSet)this.mapper.readValue(reader, DataSet.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read demo data set", e);
        }
    }

    String marshal(DataSet dataSet) {
        try {
            return this.mapper.writeValueAsString((Object)dataSet);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to marshal data set (" + dataSet.getName() + ")", e);
        }
    }

    static DataSet toDataSet(RoutingProblem routingProblem) {
        DataSet dataSet = new DataSet();
        dataSet.setName(routingProblem.name());
        dataSet.setDepot(routingProblem.depot().map(DataSetMarshaller::toDataSet).orElse(null));
        dataSet.setVehicles(routingProblem.vehicles().stream().map(DataSetMarshaller::toDataSet).collect(Collectors.toList()));
        dataSet.setVisits(routingProblem.visits().stream().map(DataSetMarshaller::toDataSet).collect(Collectors.toList()));
        return dataSet;
    }

    static DataSetLocation toDataSet(LocationData locationData) {
        return new DataSetLocation(locationData.description(), locationData.coordinates().latitude().doubleValue(), locationData.coordinates().longitude().doubleValue());
    }

    static DataSetVehicle toDataSet(VehicleData vehicleData) {
        return new DataSetVehicle(vehicleData.name(), vehicleData.capacity());
    }

    static RoutingProblem toDomain(DataSet dataSet) {
        return new RoutingProblem(Optional.ofNullable(dataSet.getName()).orElse(""), dataSet.getVehicles().stream().map(DataSetMarshaller::toDomain).collect(Collectors.toList()), Optional.ofNullable(dataSet.getDepot()).map(DataSetMarshaller::toDomain).orElse(null), dataSet.getVisits().stream().map(DataSetMarshaller::toDomain).collect(Collectors.toList()));
    }

    static LocationData toDomain(DataSetLocation dataSetLocation) {
        return new LocationData(Coordinates.valueOf(dataSetLocation.getLatitude(), dataSetLocation.getLongitude()), dataSetLocation.getLabel());
    }

    static VehicleData toDomain(DataSetVehicle dataSetVehicle) {
        return VehicleFactory.vehicleData(dataSetVehicle.name, dataSetVehicle.capacity);
    }
}

