/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoutingPlanFactory;
import org.optaweb.vehiclerouting.service.route.RoutingPlanConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
class WebSocketRoutingPlanSender
implements RoutingPlanConsumer {
    static final String TOPIC_ROUTE = "/topic/route";
    private final SimpMessagingTemplate webSocket;

    @Autowired
    WebSocketRoutingPlanSender(SimpMessagingTemplate webSocket) {
        this.webSocket = webSocket;
    }

    public void consumePlan(RoutingPlan routingPlan) {
        this.webSocket.convertAndSend((Object)TOPIC_ROUTE, (Object)PortableRoutingPlanFactory.fromRoutingPlan((RoutingPlan)routingPlan));
    }
}

