/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

@ExtendWith(value={MockitoExtension.class})
class AddVisitTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    AddVisitTest() {
    }

    @Test
    void add_visit_should_add_location_and_create_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        PlanningVisit visit = PlanningVisitFactory.testVisit((long)1L);
        AddVisit addVisit = new AddVisit(visit);
        addVisit.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeEntityAdded((Object)visit);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterEntityAdded((Object)visit);
        Assertions.assertThat((List)solution.getVisitList()).containsExactly((Object[])new PlanningVisit[]{visit});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }
}

