/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.reload;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.location.LocationService;
import org.optaweb.vehiclerouting.service.reload.ReloadService;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;
import org.optaweb.vehiclerouting.service.vehicle.VehicleService;
import org.springframework.boot.context.event.ApplicationStartedEvent;

@ExtendWith(value={MockitoExtension.class})
class ReloadServiceTest {
    @Mock
    private VehicleRepository vehicleRepository;
    @Mock
    private VehicleService vehicleService;
    @Mock
    private LocationRepository locationRepository;
    @Mock
    private LocationService locationService;
    @InjectMocks
    private ReloadService reloadService;
    @Mock
    ApplicationStartedEvent event;
    private final Vehicle vehicle = VehicleFactory.createVehicle((long)193L, (String)"Vehicle 193", (int)100);
    private final List<Vehicle> persistedVehicles = Arrays.asList(this.vehicle, this.vehicle);
    private final Coordinates coordinates = Coordinates.valueOf((double)0.0, (double)1.0);
    private final Location location = new Location(1L, this.coordinates);
    private final List<Location> persistedLocations = Arrays.asList(this.location, this.location, this.location);

    ReloadServiceTest() {
    }

    @Test
    void should_reload_on_startup() {
        Mockito.when((Object)this.vehicleRepository.vehicles()).thenReturn(this.persistedVehicles);
        Mockito.when((Object)this.locationRepository.locations()).thenReturn(this.persistedLocations);
        this.reloadService.reload(this.event);
        ((VehicleRepository)Mockito.verify((Object)this.vehicleRepository)).vehicles();
        ((VehicleService)Mockito.verify((Object)this.vehicleService, (VerificationMode)Mockito.times((int)this.persistedVehicles.size()))).addVehicle(this.vehicle);
        ((LocationRepository)Mockito.verify((Object)this.locationRepository)).locations();
        ((LocationService)Mockito.verify((Object)this.locationService, (VerificationMode)Mockito.times((int)this.persistedLocations.size()))).addLocation(this.location);
    }
}

