/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.util.EncodingManager;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.optaweb.vehiclerouting.plugin.routing.RoutingEngineException;
import org.optaweb.vehiclerouting.plugin.routing.RoutingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
class RoutingConfig {
    private static final Logger logger = LoggerFactory.getLogger(RoutingConfig.class);
    private final Path osmDir;
    private final Path osmFile;
    private final String osmDownloadUrl;
    private final Path graphHopperDir;
    private final Path graphDir;

    @Autowired
    RoutingConfig(RoutingProperties routingProperties) {
        this.osmDir = Paths.get(routingProperties.getOsmDir(), new String[0]).toAbsolutePath();
        this.osmFile = this.osmDir.resolve(routingProperties.getOsmFile()).toAbsolutePath();
        this.osmDownloadUrl = routingProperties.getOsmDownloadUrl();
        this.graphHopperDir = Paths.get(routingProperties.getGhDir(), new String[0]);
        String regionName = routingProperties.getOsmFile().replaceFirst("\\.osm\\.pbf$", "");
        this.graphDir = this.graphHopperDir.resolve(regionName).toAbsolutePath();
    }

    @Profile(value={"!test"})
    @Bean
    @ConditionalOnProperty(prefix="app.routing", name={"engine"}, havingValue="graphhopper", matchIfMissing=true)
    GraphHopperOSM graphHopper() {
        GraphHopperOSM graphHopper = (GraphHopperOSM)new GraphHopperOSM().forServer();
        graphHopper.setGraphHopperLocation(this.graphDir.toString());
        if (this.graphDir.toFile().exists()) {
            logger.info("Loading existing GraphHopper graph from: {}", (Object)this.graphDir);
        } else {
            if (!this.osmFile.toFile().exists()) {
                this.initDirs();
                if (this.osmDownloadUrl == null || this.osmDownloadUrl.trim().isEmpty()) {
                    throw new IllegalStateException("The osmFile (" + this.osmFile + ") does not exist and no download URL was provided.\nDownload the OSM file from http://download.geofabrik.de/ first or provide an OSM file URL using the app.routing.osm-download-url property.");
                }
                RoutingConfig.downloadOsmFile(this.osmDownloadUrl, this.osmFile);
            }
            logger.info("Importing OSM file: {}", (Object)this.osmFile);
            graphHopper.setOSMFile(this.osmFile.toString());
        }
        graphHopper.setEncodingManager(EncodingManager.create((String)"car"));
        graphHopper.importOrLoad();
        logger.info("GraphHopper graph loaded");
        return graphHopper;
    }

    private void initDirs() {
        try {
            Files.createDirectories(this.osmDir, new FileAttribute[0]);
            Files.createDirectories(this.graphHopperDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RoutingEngineException("Can't create directory for storing OSM download", e);
        }
    }

    static void downloadOsmFile(String urlString, Path osmFile) {
        HttpURLConnection con;
        try {
            URL url = new URL(urlString);
            con = (HttpURLConnection)url.openConnection();
        }
        catch (MalformedURLException e) {
            throw new RoutingEngineException("The OSM file URL is malformed", e);
        }
        catch (IOException e) {
            throw new RoutingEngineException("The OSM file cannot be downloaded", e);
        }
        try {
            con.setRequestMethod("GET");
        }
        catch (ProtocolException e) {
            throw new IllegalStateException("Can't set request method", e);
        }
        con.setConnectTimeout(10000);
        con.setReadTimeout(10000);
        logger.info("Downloading OSM file from {}", (Object)urlString);
        try {
            Files.copy(con.getInputStream(), osmFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RoutingEngineException("OSM file download failed", e);
        }
        logger.info("File saved to {}", (Object)osmFile);
    }
}

