/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.math.BigDecimal;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;

class CoordinatesTest {
    CoordinatesTest() {
    }

    @Test
    void constructor_params_must_not_be_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Coordinates(null, BigDecimal.ZERO));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Coordinates(BigDecimal.ZERO, null));
    }

    @Test
    void coordinates_should_be_equals_when_numerically_equal() {
        Coordinates coordinates = new Coordinates(BigDecimal.valueOf(987.1234), BigDecimal.valueOf(-0.1111));
        Assertions.assertThat((Object)coordinates).isEqualTo((Object)coordinates);
        BigDecimal ONE_POINT_ZERO = new BigDecimal("1.0");
        BigDecimal MINUS_ZERO = BigDecimal.ZERO.negate();
        Coordinates coordinates01 = new Coordinates(BigDecimal.ZERO, BigDecimal.ONE);
        ((ObjectAssert)Assertions.assertThat((Object)new Coordinates(MINUS_ZERO, ONE_POINT_ZERO)).isEqualTo((Object)coordinates01)).hasSameHashCodeAs((Object)coordinates01);
        Coordinates coordinates10 = new Coordinates(BigDecimal.ONE, BigDecimal.ZERO);
        ((ObjectAssert)Assertions.assertThat((Object)new Coordinates(ONE_POINT_ZERO, MINUS_ZERO)).isEqualTo((Object)coordinates10)).hasSameHashCodeAs((Object)coordinates10);
    }

    @Test
    void should_not_equal() {
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new Coordinates(BigDecimal.ONE, BigDecimal.TEN)).isNotEqualTo(null)).isNotEqualTo((Object)BigDecimal.valueOf(11L))).isNotEqualTo((Object)new Coordinates(BigDecimal.ONE, BigDecimal.ONE))).isNotEqualTo((Object)new Coordinates(BigDecimal.TEN, BigDecimal.TEN));
    }

    @Test
    void valueOf_and_getters() {
        double latitude = Math.E;
        double longitude = Math.PI;
        Coordinates coordinates = Coordinates.valueOf((double)latitude, (double)longitude);
        Assertions.assertThat((BigDecimal)coordinates.latitude()).isEqualTo((Object)BigDecimal.valueOf(latitude));
        Assertions.assertThat((BigDecimal)coordinates.longitude()).isEqualTo((Object)BigDecimal.valueOf(longitude));
    }
}

