/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Collections;
import java.util.concurrent.Semaphore;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.test.context.ActiveProfiles;

@SpringBootTest(properties={"optaplanner.solver-config-xml=org/optaweb/vehiclerouting/solver/vehicleRoutingSolverConfig.xml", "optaplanner.solver.termination.best-score-limit=-1hard/-120soft"}, webEnvironment=SpringBootTest.WebEnvironment.NONE)
@ActiveProfiles(value={"test"})
class SolverManagerIntegrationTest {
    @Autowired
    private SolverManager solverManager;
    @Autowired
    private RouteChangedEventSemaphore routeChangedEventSemaphore;

    SolverManagerIntegrationTest() {
    }

    private static DistanceMap mockDistanceMap() {
        return location -> 60L;
    }

    @Test
    @Timeout(value=60L)
    void solver_should_be_in_daemon_mode() throws InterruptedException {
        PlanningVehicle vehicle = PlanningVehicleFactory.testVehicle((long)1L);
        PlanningLocation depot = PlanningLocationFactory.testLocation((long)1L, (DistanceMap)SolverManagerIntegrationTest.mockDistanceMap());
        PlanningLocation visit = PlanningLocationFactory.testLocation((long)2L, (DistanceMap)SolverManagerIntegrationTest.mockDistanceMap());
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Collections.singletonList(vehicle), (PlanningDepot)new PlanningDepot(depot), Collections.singletonList(PlanningVisitFactory.fromLocation((PlanningLocation)visit)));
        this.solverManager.startSolver(solution);
        this.routeChangedEventSemaphore.waitForRouteUpdate();
        Assertions.assertThatCode(() -> this.solverManager.changeCapacity(vehicle)).doesNotThrowAnyException();
    }

    @TestConfiguration
    static class Config {
        Config() {
        }

        @Bean
        RouteChangedEventSemaphore semaphore() {
            return new RouteChangedEventSemaphore();
        }
    }

    static class RouteChangedEventSemaphore
    implements ApplicationListener<RouteChangedEvent> {
        private static final Logger logger = LoggerFactory.getLogger(RouteChangedEventSemaphore.class);
        private final Semaphore semaphore = new Semaphore(0);

        RouteChangedEventSemaphore() {
        }

        public void onApplicationEvent(RouteChangedEvent event) {
            logger.info("DISTANCE: {}", (Object)event.distance());
            this.semaphore.release();
        }

        void waitForRouteUpdate() throws InterruptedException {
            this.semaphore.acquire();
            int remainingPermits = this.semaphore.availablePermits();
            if (remainingPermits > 0) {
                throw new IllegalStateException("Only 1 RouteChangedEvent was expected but there were at least " + (remainingPermits + 1));
            }
        }
    }
}

