/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.error;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.optaweb.vehiclerouting.service.error.ErrorListener;
import org.optaweb.vehiclerouting.service.error.ErrorMessage;
import org.optaweb.vehiclerouting.service.error.ErrorMessageConsumer;

@ExtendWith(value={MockitoExtension.class})
class ErrorListenerTest {
    @Captor
    private ArgumentCaptor<ErrorMessage> argumentCaptor;

    ErrorListenerTest() {
    }

    @Test
    void should_pass_error_message_to_consumer(@Mock ErrorMessageConsumer errorMessageConsumer) {
        String text = "error";
        ErrorListener errorListener = new ErrorListener(errorMessageConsumer);
        errorListener.onApplicationEvent(new ErrorEvent((Object)this, text));
        ((ErrorMessageConsumer)Mockito.verify((Object)errorMessageConsumer)).consumeMessage((ErrorMessage)this.argumentCaptor.capture());
        ErrorMessage capturedMessage = (ErrorMessage)this.argumentCaptor.getValue();
        Assertions.assertThat((String)capturedMessage.text).isEqualTo(text);
        Assertions.assertThat((String)capturedMessage.id).isNotNull();
    }
}

