/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.region;

import java.util.Objects;
import org.optaweb.vehiclerouting.domain.Coordinates;

public class BoundingBox {
    private final Coordinates southWest;
    private final Coordinates northEast;

    public BoundingBox(Coordinates southWest, Coordinates northEast) {
        this.southWest = Objects.requireNonNull(southWest);
        this.northEast = Objects.requireNonNull(northEast);
        if (southWest.latitude().compareTo(northEast.latitude()) >= 0) {
            throw new IllegalArgumentException("South-west corner latitude (" + southWest.latitude() + "N) must be less than north-east corner latitude (" + northEast.latitude() + "N)");
        }
        if (southWest.longitude().compareTo(northEast.longitude()) >= 0) {
            throw new IllegalArgumentException("South-west corner longitude (" + southWest.longitude() + "E) must be less than north-east corner longitude (" + northEast.longitude() + "E)");
        }
    }

    public Coordinates getSouthWest() {
        return this.southWest;
    }

    public Coordinates getNorthEast() {
        return this.northEast;
    }
}

