/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

@ExtendWith(value={MockitoExtension.class})
class RemoveVisitTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    RemoveVisitTest() {
    }

    @Test
    void remove_last_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        PlanningVisit removedVisit = PlanningVisitFactory.testVisit((long)1L);
        PlanningVisit otherVisit = PlanningVisitFactory.testVisit((long)2L);
        solution.getVisitList().add(otherVisit);
        solution.getVisitList().add(removedVisit);
        otherVisit.setPreviousStandstill((Standstill)PlanningVehicleFactory.testVehicle((long)10L));
        otherVisit.setNextVisit(removedVisit);
        removedVisit.setPreviousStandstill((Standstill)otherVisit);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVisit)).thenReturn((Object)removedVisit);
        RemoveVisit removeVisit = new RemoveVisit(removedVisit);
        removeVisit.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeEntityRemoved((Object)removedVisit);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterEntityRemoved((Object)removedVisit);
        Assertions.assertThat((List)solution.getVisitList()).containsExactly((Object[])new PlanningVisit[]{otherVisit});
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void remove_middle_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        PlanningVisit firstVisit = PlanningVisitFactory.testVisit((long)1L);
        PlanningVisit middleVisit = PlanningVisitFactory.testVisit((long)2L);
        PlanningVisit lastVisit = PlanningVisitFactory.testVisit((long)3L);
        solution.getVisitList().add(firstVisit);
        solution.getVisitList().add(lastVisit);
        solution.getVisitList().add(middleVisit);
        firstVisit.setPreviousStandstill((Standstill)PlanningVehicleFactory.testVehicle((long)1L));
        firstVisit.setNextVisit(middleVisit);
        middleVisit.setPreviousStandstill((Standstill)firstVisit);
        middleVisit.setNextVisit(lastVisit);
        lastVisit.setPreviousStandstill((Standstill)middleVisit);
        PlanningVisit removedVisit = PlanningVisitFactory.testVisit((long)2L);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVisit)).thenReturn((Object)middleVisit);
        RemoveVisit removeVisit = new RemoveVisit(removedVisit);
        removeVisit.doChange(this.scoreDirector);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeVariableChanged((Object)lastVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterVariableChanged((Object)lastVisit, "previousStandstill");
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeEntityRemoved((Object)middleVisit);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterEntityRemoved((Object)middleVisit);
        ((ListAssert)Assertions.assertThat((List)solution.getVisitList()).hasSize(2)).containsOnly((Object[])new PlanningVisit[]{firstVisit, lastVisit});
        Assertions.assertThat((Object)lastVisit.getPreviousStandstill()).isEqualTo((Object)firstVisit);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_solution_visit_list_does_not_contain_working_visit() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        long removedId = 111L;
        PlanningVisit removedVisit = PlanningVisitFactory.testVisit((long)removedId);
        long wrongId = 222L;
        PlanningVisit wrongVisit = PlanningVisitFactory.testVisit((long)wrongId);
        wrongVisit.setPreviousStandstill((Standstill)PlanningVisitFactory.testVisit((long)10L));
        removedVisit.setNextVisit(wrongVisit);
        solution.getVisitList().add(wrongVisit);
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)solution);
        Mockito.when((Object)this.scoreDirector.lookUpWorkingObject((Object)removedVisit)).thenReturn((Object)removedVisit);
        RemoveVisit removeVisit = new RemoveVisit(removedVisit);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> removeVisit.doChange(this.scoreDirector)).withMessageMatching(".*List .*" + wrongId + ".* doesn't contain the working.*" + removedId + ".*");
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        Mockito.when((Object)this.scoreDirector.getWorkingSolution()).thenReturn((Object)SolutionFactory.emptySolution());
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new RemoveVisit(PlanningVisitFactory.testVisit((long)0L)).doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }
}

