/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import java.io.IOException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.plugin.websocket.DataSetDownloadController;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

@ExtendWith(value={MockitoExtension.class})
class DataSetDownloadControllerTest {
    @Mock
    private DemoService demoService;
    @InjectMocks
    private DataSetDownloadController controller;

    DataSetDownloadControllerTest() {
    }

    @Test
    void export() throws IOException {
        String msg = "dummy string";
        Mockito.when((Object)this.demoService.exportDataSet()).thenReturn((Object)msg);
        ResponseEntity responseEntity = this.controller.exportDataSet();
        Assertions.assertThat((Comparable)responseEntity.getStatusCode()).isEqualTo((Object)HttpStatus.OK);
        HttpHeaders headers = responseEntity.getHeaders();
        Assertions.assertThat((long)headers.getContentLength()).isEqualTo((long)msg.length());
        Assertions.assertThat((Comparable)headers.getContentType()).isNotNull();
        Assertions.assertThat((String)headers.getContentType().toString()).isEqualToIgnoringWhitespace((CharSequence)"text/x-yaml;charset=UTF-8");
        Assertions.assertThat((Object)headers.getContentDisposition()).isNotNull();
        String contentDisposition = headers.getContentDisposition().toString();
        ((AbstractStringAssert)Assertions.assertThat((String)contentDisposition).startsWith((CharSequence)"attachment;")).containsPattern((CharSequence)"; *filename=\".*\\.yaml\"");
    }

    @Test
    void content_length_should_be_number_of_bytes() throws IOException {
        String msg = "\u0985";
        Mockito.when((Object)this.demoService.exportDataSet()).thenReturn((Object)msg);
        ResponseEntity responseEntity = this.controller.exportDataSet();
        Assertions.assertThat((long)responseEntity.getHeaders().getContentLength()).isEqualTo(3L);
    }
}

