/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.service.distance.DistanceCalculator;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.Region;
import org.optaweb.vehiclerouting.service.route.Router;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="app.routing", name={"engine"}, havingValue="air")
public class AirDistanceRouter
implements Router,
DistanceCalculator,
Region {
    protected static final int TRAVEL_SPEED_KPH = 60;
    protected static final double KILOMETERS_PER_DEGREE = 111.0;
    protected static final long MILLIS_IN_ONE_HOUR = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);

    @Override
    public long travelTimeMillis(Coordinates from, Coordinates to) {
        BigDecimal latDiff = to.latitude().subtract(from.latitude());
        BigDecimal lngDiff = to.longitude().subtract(from.longitude());
        double distanceKilometers = Math.sqrt(latDiff.pow(2).add(lngDiff.pow(2)).doubleValue()) * 111.0;
        return (long)Math.floor(distanceKilometers / 60.0 * (double)MILLIS_IN_ONE_HOUR);
    }

    @Override
    public List<Coordinates> getPath(Coordinates from, Coordinates to) {
        return Arrays.asList(from, to);
    }

    @Override
    public BoundingBox getBounds() {
        return new BoundingBox(Coordinates.valueOf(-90.0, -180.0), Coordinates.valueOf(90.0, 180.0));
    }
}

