/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaweb.vehiclerouting.plugin.planner.RouteChangedEventPublisher;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVisit;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;

@Component(value="optaweb-solver-manager")
class SolverManager
implements SolverEventListener<VehicleRoutingSolution> {
    private static final Logger logger = LoggerFactory.getLogger(SolverManager.class);
    private final Solver<VehicleRoutingSolution> solver;
    private final AsyncListenableTaskExecutor executor;
    private final RouteChangedEventPublisher routeChangedEventPublisher;
    private final ApplicationEventPublisher eventPublisher;
    private ListenableFuture<VehicleRoutingSolution> solverFuture;

    @Autowired
    SolverManager(Solver<VehicleRoutingSolution> solver, AsyncListenableTaskExecutor executor, RouteChangedEventPublisher routeChangedEventPublisher, ApplicationEventPublisher eventPublisher) {
        this.solver = solver;
        this.executor = executor;
        this.routeChangedEventPublisher = routeChangedEventPublisher;
        this.eventPublisher = eventPublisher;
        this.solver.addEventListener((SolverEventListener)this);
    }

    public void bestSolutionChanged(BestSolutionChangedEvent<VehicleRoutingSolution> bestSolutionChangedEvent) {
        if (!bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()) {
            logger.info("Ignoring a new best solution that has some problem facts missing");
            return;
        }
        this.routeChangedEventPublisher.publishSolution((VehicleRoutingSolution)bestSolutionChangedEvent.getNewBestSolution());
    }

    void startSolver(VehicleRoutingSolution solution) {
        if (this.solverFuture != null) {
            throw new IllegalStateException("Solver start has already been requested");
        }
        this.solverFuture = this.executor.submitListenable((Callable)((SolvingTask)() -> (VehicleRoutingSolution)this.solver.solve((Object)solution)));
        this.solverFuture.addCallback(result -> {
            if (!this.solver.isTerminateEarly()) {
                logger.error("Solver stopped solving but that shouldn't happen in daemon mode.");
                this.eventPublisher.publishEvent((ApplicationEvent)new ErrorEvent((Object)this, "Solver stopped solving unexpectedly."));
            }
        }, exception -> {
            logger.error("Solver failed", exception);
            this.eventPublisher.publishEvent((ApplicationEvent)new ErrorEvent((Object)this, exception.toString()));
        });
    }

    void stopSolver() {
        if (this.solverFuture != null) {
            this.solver.terminateEarly();
            try {
                this.solverFuture.get();
                this.solverFuture = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Failed to stop solver", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to stop solver", e.getCause());
            }
        }
    }

    private void assertSolverIsAlive() {
        if (this.solverFuture == null) {
            throw new IllegalStateException("Solver has not started yet");
        }
        if (this.solverFuture.isDone()) {
            try {
                this.solverFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Solver has died", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Solver has died", e.getCause());
            }
            throw new IllegalStateException("Solver has finished solving even though it operates in daemon mode");
        }
    }

    void addVisit(PlanningVisit visit) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new AddVisit(visit));
    }

    void removeVisit(PlanningVisit visit) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new RemoveVisit(visit));
    }

    void addVehicle(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new AddVehicle(vehicle));
    }

    void removeVehicle(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new RemoveVehicle(vehicle));
    }

    void changeCapacity(PlanningVehicle vehicle) {
        this.assertSolverIsAlive();
        this.solver.addProblemFactChange((ProblemFactChange)new ChangeVehicleCapacity(vehicle));
    }
}

