/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import java.util.Objects;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

public class ChangeVehicleCapacity
implements ProblemFactChange<VehicleRoutingSolution> {
    private final PlanningVehicle vehicle;

    public ChangeVehicleCapacity(PlanningVehicle vehicle) {
        this.vehicle = Objects.requireNonNull(vehicle);
    }

    public void doChange(ScoreDirector<VehicleRoutingSolution> scoreDirector) {
        PlanningVehicle workingVehicle = (PlanningVehicle)scoreDirector.lookUpWorkingObject((Object)this.vehicle);
        if (workingVehicle == null) {
            throw new IllegalStateException("Can't look up a working copy of " + this.vehicle);
        }
        scoreDirector.beforeProblemPropertyChanged((Object)workingVehicle);
        workingVehicle.setCapacity(this.vehicle.getCapacity());
        scoreDirector.afterProblemPropertyChanged((Object)workingVehicle);
        scoreDirector.triggerVariableListeners();
    }
}

