/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.change;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaplanner.core.impl.score.director.ScoreDirector;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

@ExtendWith(value={MockitoExtension.class})
class ChangeVehicleCapacityTest {
    @Mock
    private ScoreDirector<VehicleRoutingSolution> scoreDirector;

    ChangeVehicleCapacityTest() {
    }

    @Test
    void change_vehicle_capacity() {
        int oldCapacity = 100;
        int newCapacity = 50;
        PlanningVehicle workingVehicle = PlanningVehicleFactory.testVehicle((long)1L, (int)oldCapacity);
        PlanningVehicle changeVehicle = PlanningVehicleFactory.testVehicle((long)2L, (int)newCapacity);
        Mockito.when((Object)((PlanningVehicle)this.scoreDirector.lookUpWorkingObject((Object)changeVehicle))).thenReturn((Object)workingVehicle);
        ChangeVehicleCapacity changeVehicleCapacity = new ChangeVehicleCapacity(changeVehicle);
        changeVehicleCapacity.doChange(this.scoreDirector);
        Assertions.assertThat((int)workingVehicle.getCapacity()).isEqualTo(newCapacity);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).beforeProblemPropertyChanged((Object)workingVehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).afterProblemPropertyChanged((Object)workingVehicle);
        ((ScoreDirector)Mockito.verify(this.scoreDirector)).triggerVariableListeners();
    }

    @Test
    void fail_fast_if_working_object_is_null() {
        ChangeVehicleCapacity changeVehicleCapacity = new ChangeVehicleCapacity(PlanningVehicleFactory.testVehicle((long)1L));
        Assertions.assertThatIllegalStateException().isThrownBy(() -> changeVehicleCapacity.doChange(this.scoreDirector)).withMessageContaining("working copy of");
    }
}

