/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVisit;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolverIntegrationTest {
    private static final Logger logger = LoggerFactory.getLogger(SolverIntegrationTest.class);
    private SolverConfig solverConfig;
    private ExecutorService executor;
    private ProblemFactChangeProcessingMonitor monitor;
    private Future<VehicleRoutingSolution> futureSolution;

    SolverIntegrationTest() {
    }

    @BeforeEach
    void setUp() {
        this.solverConfig = SolverConfig.createFromXmlResource((String)"org/optaweb/vehiclerouting/solver/vehicleRoutingSolverConfig.xml");
        this.solverConfig.setDaemon(Boolean.valueOf(true));
        this.executor = Executors.newSingleThreadExecutor();
        this.monitor = new ProblemFactChangeProcessingMonitor();
    }

    @AfterEach
    void tearDown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(1L, TimeUnit.SECONDS);
    }

    @Disabled(value="Solver fails fast on empty value ranges")
    @Test
    void solver_in_daemon_mode_should_not_fail_on_empty_solution() {
        Solver solver = SolverFactory.create((SolverConfig)this.solverConfig).buildSolver();
        Assertions.assertThat((Object)((VehicleRoutingSolution)solver.solve((Object)SolutionFactory.emptySolution()))).isNotNull();
    }

    @Test
    void removing_visits_should_not_fail() {
        long distance = 1L;
        PlanningVehicle vehicle = PlanningVehicleFactory.testVehicle((long)1L);
        VehicleRoutingSolution solution = SolutionFactory.solutionFromVisits(Collections.singletonList(vehicle), (PlanningDepot)new PlanningDepot(PlanningLocationFactory.testLocation((long)1L, location -> distance)), Collections.singletonList(PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)2L, location -> distance))));
        Solver solver = SolverFactory.create((SolverConfig)this.solverConfig).buildSolver();
        solver.addEventListener((SolverEventListener)this.monitor);
        this.startSolver((Solver<VehicleRoutingSolution>)solver, solution);
        for (int id = 3; id < 6; ++id) {
            logger.info("Add visit ({})", (Object)id);
            this.monitor.beforeProblemFactChange();
            solver.addProblemFactChange((ProblemFactChange)new AddVisit(PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)id, location -> distance))));
            Assertions.assertThat((boolean)this.monitor.awaitAllProblemFactChanges(1000)).isTrue();
        }
        List<Integer> visitIds = Arrays.asList(5, 2, 3);
        for (int id : visitIds) {
            logger.info("Remove visit ({})", (Object)id);
            Assertions.assertThat((boolean)solver.isEveryProblemFactChangeProcessed()).isTrue();
            this.monitor.beforeProblemFactChange();
            solver.addProblemFactChange((ProblemFactChange)new RemoveVisit(PlanningVisitFactory.testVisit((long)id)));
            Assertions.assertThat((boolean)solver.isEveryProblemFactChangeProcessed()).isFalse();
            if (this.monitor.awaitAllProblemFactChanges(1000)) continue;
            Assertions.assertThat((Object)this.terminateSolver((Solver<VehicleRoutingSolution>)solver)).isNotNull();
            Assertions.fail((String)"Problem fact change hasn't been completed");
        }
        Assertions.assertThat((Object)this.terminateSolver((Solver<VehicleRoutingSolution>)solver)).isNotNull();
    }

    private void startSolver(Solver<VehicleRoutingSolution> solver, VehicleRoutingSolution solution) {
        this.futureSolution = this.executor.submit(() -> (VehicleRoutingSolution)solver.solve((Object)solution));
    }

    private VehicleRoutingSolution terminateSolver(Solver<VehicleRoutingSolution> solver) {
        solver.terminateEarly();
        try {
            return this.futureSolution.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Assertions.fail((String)"Interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            Assertions.fail((String)"Solving failed", (Throwable)e);
        }
        throw new AssertionError();
    }

    static class ProblemFactChangeProcessingMonitor
    implements SolverEventListener<VehicleRoutingSolution> {
        private static final Logger logger = LoggerFactory.getLogger(ProblemFactChangeProcessingMonitor.class);
        private final Semaphore problemFactChanges = new Semaphore(0);

        ProblemFactChangeProcessingMonitor() {
        }

        void beforeProblemFactChange() {
            int permitsDrained = this.problemFactChanges.drainPermits();
            logger.debug("Before PFC (permits drained: {})", (Object)permitsDrained);
        }

        boolean awaitAllProblemFactChanges(int milliseconds) {
            logger.debug("WAIT (completed PFCs: {})", (Object)this.problemFactChanges.availablePermits());
            try {
                if (this.problemFactChanges.tryAcquire(milliseconds, TimeUnit.MILLISECONDS)) {
                    logger.info("Problem Fact Change DONE");
                    return true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Assertions.fail((String)"Interrupted", (Throwable)e);
            }
            return false;
        }

        public void bestSolutionChanged(BestSolutionChangedEvent<VehicleRoutingSolution> event) {
            if (!event.isEveryProblemFactChangeProcessed()) {
                logger.debug("UNPROCESSED");
            } else if (!event.getNewBestScore().isSolutionInitialized()) {
                logger.debug("UNINITIALIZED ({})", (Object)event.getNewBestScore());
            } else {
                logger.debug("New best solution (COMPLETE)");
                this.problemFactChanges.release();
            }
        }
    }
}

