/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaweb.vehiclerouting.plugin.planner.RouteChangedEventPublisher;
import org.optaweb.vehiclerouting.plugin.planner.SolverManager;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.AddVisit;
import org.optaweb.vehiclerouting.plugin.planner.change.ChangeVehicleCapacity;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVehicle;
import org.optaweb.vehiclerouting.plugin.planner.change.RemoveVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.SolutionFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

@ExtendWith(value={MockitoExtension.class})
class SolverManagerTest {
    private final VehicleRoutingSolution solution = SolutionFactory.emptySolution();
    private final PlanningVehicle testVehicle = PlanningVehicleFactory.testVehicle((long)1L);
    private final PlanningVisit testVisit = PlanningVisitFactory.testVisit((long)1L);
    @Captor
    private ArgumentCaptor<VehicleRoutingSolution> solutionArgumentCaptor;
    @Mock
    private BestSolutionChangedEvent<VehicleRoutingSolution> bestSolutionChangedEvent;
    @Mock
    private ListenableFuture<VehicleRoutingSolution> solverFuture;
    @Mock
    private Solver<VehicleRoutingSolution> solver;
    @Mock
    private AsyncListenableTaskExecutor executor;
    @Mock
    private RouteChangedEventPublisher routeChangedEventPublisher;
    @InjectMocks
    private SolverManager solverManager;

    SolverManagerTest() {
    }

    private void returnSolverFutureWhenSolverIsStarted() {
        Mockito.when((Object)this.executor.submitListenable((Callable)ArgumentMatchers.any(SolverManager.SolvingTask.class))).thenAnswer(AdditionalAnswers.answer(callable -> {
            callable.call();
            return this.solverFuture;
        }));
    }

    @Test
    void should_listen_for_best_solution_events() {
        ((Solver)Mockito.verify(this.solver)).addEventListener((SolverEventListener)this.solverManager);
    }

    @Test
    void ignore_new_best_solutions_when_unprocessed_fact_changes() {
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)false);
        this.solverManager.bestSolutionChanged(this.bestSolutionChangedEvent);
        ((BestSolutionChangedEvent)Mockito.verify(this.bestSolutionChangedEvent, (VerificationMode)Mockito.never())).getNewBestSolution();
        ((RouteChangedEventPublisher)Mockito.verify((Object)this.routeChangedEventPublisher, (VerificationMode)Mockito.never())).publishSolution((VehicleRoutingSolution)ArgumentMatchers.any());
    }

    @Test
    void publish_new_best_solution_if_all_fact_changes_processed() {
        VehicleRoutingSolution solution = SolutionFactory.emptySolution();
        Mockito.when((Object)this.bestSolutionChangedEvent.isEveryProblemFactChangeProcessed()).thenReturn((Object)true);
        Mockito.when((Object)((VehicleRoutingSolution)this.bestSolutionChangedEvent.getNewBestSolution())).thenReturn((Object)solution);
        this.solverManager.bestSolutionChanged(this.bestSolutionChangedEvent);
        ((RouteChangedEventPublisher)Mockito.verify((Object)this.routeChangedEventPublisher)).publishSolution((VehicleRoutingSolution)this.solutionArgumentCaptor.capture());
        VehicleRoutingSolution event = (VehicleRoutingSolution)this.solutionArgumentCaptor.getValue();
        Assertions.assertThat((Object)event).isSameAs((Object)solution);
    }

    @Test
    void startSolver_should_start_solver() {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver(this.solution);
        ((Solver)Mockito.verify(this.solver)).solve((Object)this.solution);
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.startSolver(this.solution));
    }

    @Test
    void stopSolver_should_terminate_solver() {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver(this.solution);
        this.solverManager.stopSolver();
        ((Solver)Mockito.verify(this.solver)).terminateEarly();
        this.solverManager.stopSolver();
        ((Solver)Mockito.verify(this.solver)).terminateEarly();
    }

    @Test
    void reset_interrupted_flag() throws ExecutionException, InterruptedException {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver(this.solution);
        Mockito.when((Object)this.solverFuture.isDone()).thenReturn((Object)true);
        Mockito.when((Object)((VehicleRoutingSolution)this.solverFuture.get())).thenThrow(InterruptedException.class);
        PlanningVisit visit = PlanningVisitFactory.testVisit((long)0L);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.removeVisit(visit));
        Assertions.assertThat((boolean)Thread.interrupted()).isTrue();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.stopSolver());
        Assertions.assertThat((boolean)Thread.interrupted()).isTrue();
    }

    @Test
    void change_operations_should_fail_if_solver_has_not_started_yet() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.addVehicle(this.testVehicle)).withMessageContaining("started");
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.removeVehicle(this.testVehicle)).withMessageContaining("started");
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.changeCapacity(this.testVehicle)).withMessageContaining("started");
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.addVisit(this.testVisit)).withMessageContaining("started");
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.solverManager.removeVisit(this.testVisit)).withMessageContaining("started");
    }

    @Test
    void change_operations_should_fail_is_solver_has_died() throws ExecutionException, InterruptedException {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver(this.solution);
        Mockito.when((Object)this.solverFuture.isDone()).thenReturn((Object)true);
        Mockito.when((Object)((VehicleRoutingSolution)this.solverFuture.get())).thenThrow(ExecutionException.class);
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.addVehicle(this.testVehicle)).withMessageContaining("died");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.removeVehicle(this.testVehicle)).withMessageContaining("died");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.changeCapacity(this.testVehicle)).withMessageContaining("died");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.addVisit(this.testVisit)).withMessageContaining("died");
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.solverManager.removeVisit(this.testVisit)).withMessageContaining("died");
    }

    @Test
    void change_operations_should_submit_problem_fact_changes_to_solver() {
        this.returnSolverFutureWhenSolverIsStarted();
        this.solverManager.startSolver(this.solution);
        Mockito.when((Object)this.solverFuture.isDone()).thenReturn((Object)false);
        this.solverManager.addVehicle(this.testVehicle);
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(AddVehicle.class));
        this.solverManager.removeVehicle(this.testVehicle);
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(RemoveVehicle.class));
        this.solverManager.changeCapacity(this.testVehicle);
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(ChangeVehicleCapacity.class));
        this.solverManager.addVisit(this.testVisit);
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(AddVisit.class));
        this.solverManager.removeVisit(this.testVisit);
        ((Solver)Mockito.verify(this.solver)).addProblemFactChange((ProblemFactChange)ArgumentMatchers.any(RemoveVisit.class));
    }
}

