/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.optaweb.vehiclerouting.domain.Coordinates;

class PortableCoordinates {
    private static final int LATLNG_SCALE = 5;
    @JsonProperty(value="lat")
    private final BigDecimal latitude;
    @JsonProperty(value="lng")
    private final BigDecimal longitude;

    static PortableCoordinates fromCoordinates(Coordinates coordinates) {
        Objects.requireNonNull(coordinates, "coordinates must not be null");
        return new PortableCoordinates(coordinates.latitude(), coordinates.longitude());
    }

    private static BigDecimal scale(BigDecimal number) {
        return number.setScale(Math.min(number.scale(), 5), RoundingMode.HALF_EVEN).stripTrailingZeros();
    }

    PortableCoordinates(BigDecimal latitude, BigDecimal longitude) {
        this.latitude = PortableCoordinates.scale(latitude);
        this.longitude = PortableCoordinates.scale(longitude);
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortableCoordinates that = (PortableCoordinates)o;
        return Objects.equals(this.latitude, that.latitude) && Objects.equals(this.longitude, that.longitude);
    }

    public int hashCode() {
        return Objects.hash(this.latitude, this.longitude);
    }

    public String toString() {
        return "PortableCoordinates{latitude=" + this.latitude + ", longitude=" + this.longitude + "}";
    }
}

