/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import java.util.Objects;
import org.optaweb.vehiclerouting.domain.Vehicle;

class PortableVehicle {
    private final long id;
    private final String name;
    private final int capacity;

    static PortableVehicle fromVehicle(Vehicle vehicle) {
        Objects.requireNonNull(vehicle, "vehicle must not be null");
        return new PortableVehicle(vehicle.id(), vehicle.name(), vehicle.capacity());
    }

    PortableVehicle(long id, String name, int capacity) {
        this.id = id;
        this.name = Objects.requireNonNull(name);
        this.capacity = capacity;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortableVehicle vehicle = (PortableVehicle)o;
        return this.id == vehicle.id && this.capacity == vehicle.capacity && this.name.equals(vehicle.name);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.capacity);
    }

    public String toString() {
        return "PortableVehicle{id=" + this.id + ", name='" + this.name + "', capacity=" + this.capacity + "}";
    }
}

