/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner.domain;

import org.optaplanner.core.api.domain.entity.PlanningEntity;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.variable.AnchorShadowVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariable;
import org.optaplanner.core.api.domain.variable.PlanningVariableGraphType;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.weight.DepotAngleVisitDifficultyWeightFactory;

@PlanningEntity(difficultyWeightFactoryClass=DepotAngleVisitDifficultyWeightFactory.class)
public class PlanningVisit
implements Standstill {
    @PlanningId
    private long id;
    private PlanningLocation location;
    private int demand;
    @PlanningVariable(valueRangeProviderRefs={"vehicleRange", "visitRange"}, graphType=PlanningVariableGraphType.CHAINED)
    private Standstill previousStandstill;
    private PlanningVisit nextVisit;
    @AnchorShadowVariable(sourceVariableName="previousStandstill")
    private PlanningVehicle vehicle;

    PlanningVisit() {
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public PlanningLocation getLocation() {
        return this.location;
    }

    public void setLocation(PlanningLocation location) {
        this.location = location;
    }

    public int getDemand() {
        return this.demand;
    }

    public void setDemand(int demand) {
        this.demand = demand;
    }

    public Standstill getPreviousStandstill() {
        return this.previousStandstill;
    }

    public void setPreviousStandstill(Standstill previousStandstill) {
        this.previousStandstill = previousStandstill;
    }

    public PlanningVisit getNextVisit() {
        return this.nextVisit;
    }

    public void setNextVisit(PlanningVisit nextVisit) {
        this.nextVisit = nextVisit;
    }

    public PlanningVehicle getVehicle() {
        return this.vehicle;
    }

    public void setVehicle(PlanningVehicle vehicle) {
        this.vehicle = vehicle;
    }

    public long distanceFromPreviousStandstill() {
        if (this.previousStandstill == null) {
            throw new IllegalStateException("This method must not be called when the previousStandstill (null) is not initialized yet.");
        }
        return this.previousStandstill.getLocation().distanceTo(this.location);
    }

    public long distanceToDepot() {
        return this.location.distanceTo(this.vehicle.getLocation());
    }

    public boolean isLast() {
        return this.nextVisit == null;
    }

    public String toString() {
        return "PlanningVisit{" + (this.location == null ? "" : "location=" + this.location.getId()) + ",demand=" + this.demand + (this.previousStandstill == null ? "" : ",previousStandstill='" + this.previousStandstill.getLocation().getId()) + (this.nextVisit == null ? "" : ",nextVisit=" + this.nextVisit.getId()) + (this.vehicle == null ? "" : ",vehicle=" + this.vehicle.getId()) + ",id=" + this.id + '}';
    }
}

