/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.plugin.websocket.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.websocket.PortableDistance;
import org.optaweb.vehiclerouting.plugin.websocket.PortableLocation;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoute;
import org.optaweb.vehiclerouting.plugin.websocket.PortableRoutingPlan;
import org.optaweb.vehiclerouting.plugin.websocket.PortableVehicle;

/*
 * Exception performing whole class analysis ignored.
 */
class PortableRoutingPlanFactory {
    private PortableRoutingPlanFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    static PortableRoutingPlan fromRoutingPlan(RoutingPlan routingPlan) {
        PortableDistance distance = PortableDistance.fromDistance((Distance)routingPlan.distance());
        List vehicles = PortableRoutingPlanFactory.portableVehicles((List)routingPlan.vehicles());
        PortableLocation depot = routingPlan.depot().map(PortableLocation::fromLocation).orElse(null);
        List visits = PortableRoutingPlanFactory.portableVisits((List)routingPlan.visits());
        List routes = routingPlan.routes().stream().map(routeWithTrack -> new PortableRoute(PortableVehicle.fromVehicle((Vehicle)routeWithTrack.vehicle()), depot, PortableRoutingPlanFactory.portableVisits((List)routeWithTrack.visits()), PortableRoutingPlanFactory.portableTrack((List)routeWithTrack.track()))).collect(Collectors.toList());
        return new PortableRoutingPlan(distance, vehicles, depot, visits, routes);
    }

    private static List<List<PortableCoordinates>> portableTrack(List<List<Coordinates>> track) {
        ArrayList<List<PortableCoordinates>> portableTrack = new ArrayList<List<PortableCoordinates>>();
        for (List<Coordinates> segment : track) {
            List portableSegment = segment.stream().map(PortableCoordinates::fromCoordinates).collect(Collectors.toList());
            portableTrack.add(portableSegment);
        }
        return portableTrack;
    }

    private static List<PortableLocation> portableVisits(List<Location> visits) {
        return visits.stream().map(PortableLocation::fromLocation).collect(Collectors.toList());
    }

    private static List<PortableVehicle> portableVehicles(List<Vehicle> vehicles) {
        return vehicles.stream().map(PortableVehicle::fromVehicle).collect(Collectors.toList());
    }
}

