/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.demo;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.service.demo.RoutingProblemList;

class RoutingProblemListTest {
    RoutingProblemListTest() {
    }

    @Test
    void should_validate_constructor_arguments() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new RoutingProblemList(null));
    }

    @Test
    void should_fail_on_duplicate_problem_names() {
        String name = "DUPLICATE_NAME";
        RoutingProblem p1 = new RoutingProblem(name, Collections.emptyList(), null, Collections.emptyList());
        RoutingProblem p2 = new RoutingProblem(name, Collections.emptyList(), null, Collections.emptyList());
        Assertions.assertThatIllegalStateException().isThrownBy(() -> new RoutingProblemList(Stream.of(p1, p2))).withMessageContaining(name);
    }

    @Test
    void all_by_name_should_return_expected_problems() {
        List vehicles = Collections.emptyList();
        Location depot = new Location(0L, Coordinates.valueOf((double)10.0, (double)-20.0));
        List visits = Collections.emptyList();
        String name1 = "Problem A";
        String name2 = "Problem B";
        RoutingProblemList routingProblemList = new RoutingProblemList(Stream.of(new RoutingProblem(name1, vehicles, (LocationData)depot, visits), new RoutingProblem(name2, vehicles, (LocationData)depot, visits)));
        Assertions.assertThat((Iterable)routingProblemList.all()).extracting("name").containsExactlyInAnyOrder(new Object[]{name1, name2});
        Assertions.assertThat((String)routingProblemList.byName(name1).name()).isEqualTo(name1);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> routingProblemList.byName("Unknown problem"));
    }
}

