/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectMock;
import java.util.Optional;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.LocationService;

@QuarkusTest
class LocationServiceIntegrationTest {
    @InjectMock
    DistanceMatrix distanceMatrix;
    @Inject
    LocationService locationService;

    LocationServiceIntegrationTest() {
    }

    @Test
    void location_service_should_be_transactional() {
        Mockito.when((Object)this.distanceMatrix.addLocation((Location)ArgumentMatchers.any())).thenReturn(locationId -> Distance.ZERO);
        Mockito.when((Object)this.distanceMatrix.distance((Location)ArgumentMatchers.any(), (Location)ArgumentMatchers.any())).thenReturn((Object)Distance.ZERO);
        this.locationService.addLocation(new Location(1000L, Coordinates.valueOf((double)-1.0, (double)12.0)));
        this.locationService.createLocation(Coordinates.valueOf((double)12.0, (double)-1.0), "location 1");
        Optional location = this.locationService.createLocation(Coordinates.valueOf((double)32.0, (double)-5.0), "location 2");
        Assertions.assertThat((Optional)location).isNotEmpty();
        this.locationService.populateDistanceMatrix();
        this.locationService.removeLocation(((Location)location.get()).id());
        this.locationService.removeAll();
    }
}

