/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.route;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.RouteWithTrack;
import org.optaweb.vehiclerouting.domain.RoutingPlan;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.optaweb.vehiclerouting.service.route.RouteListener;
import org.optaweb.vehiclerouting.service.route.Router;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;
import org.optaweb.vehiclerouting.service.vehicle.VehicleRepository;

@ExtendWith(value={MockitoExtension.class})
class RouteListenerTest {
    @Mock
    private Router router;
    @Mock
    private VehicleRepository vehicleRepository;
    @Mock
    private LocationRepository locationRepository;
    @Mock
    private Event<RoutingPlan> routingPlanEvent;
    @Captor
    private ArgumentCaptor<RoutingPlan> routeArgumentCaptor;
    @InjectMocks
    private RouteListener routeListener;

    RouteListenerTest() {
    }

    @Test
    void new_listener_should_return_empty_best_route() {
        Assertions.assertThat((boolean)this.routeListener.getBestRoutingPlan().isEmpty()).isTrue();
    }

    @Test
    void event_with_no_routes_should_be_consumed_as_an_empty_routing_plan() {
        long vehicleId = 12L;
        Vehicle vehicle = VehicleFactory.testVehicle((long)12L);
        Mockito.when((Object)this.vehicleRepository.find(12L)).thenReturn(Optional.of(vehicle));
        RouteChangedEvent event = new RouteChangedEvent((Object)this, Distance.ZERO, Collections.singletonList(12L), null, Collections.emptyList(), Collections.emptyList());
        this.routeListener.onApplicationEvent(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.router});
        RoutingPlan routingPlan = this.verifyAndCaptureConsumedPlan();
        Assertions.assertThat((List)routingPlan.vehicles()).containsExactly((Object[])new Vehicle[]{vehicle});
        Assertions.assertThat((Optional)routingPlan.depot()).isEmpty();
        Assertions.assertThat((List)routingPlan.visits()).isEmpty();
        Assertions.assertThat((List)routingPlan.routes()).isEmpty();
    }

    @Test
    void event_with_no_visits_and_a_depot_should_be_consumed_as_plan_with_empty_routes() {
        Coordinates depotCoordinates = Coordinates.valueOf((double)0.0, (double)0.1);
        Location depot = new Location(1L, depotCoordinates);
        long vehicleId = 448L;
        Vehicle vehicle = VehicleFactory.testVehicle((long)448L);
        ShallowRoute route = new ShallowRoute(vehicle.id(), depot.id(), Collections.emptyList());
        Mockito.when((Object)this.vehicleRepository.find(448L)).thenReturn(Optional.of(vehicle));
        Mockito.when((Object)this.locationRepository.find(depot.id())).thenReturn(Optional.of(depot));
        RouteChangedEvent event = new RouteChangedEvent((Object)this, Distance.ofMillis((long)5000L), Collections.singletonList(448L), Long.valueOf(depot.id()), Collections.emptyList(), Collections.singletonList(route));
        this.routeListener.onApplicationEvent(event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.router});
        RoutingPlan routingPlan = this.verifyAndCaptureConsumedPlan();
        Assertions.assertThat((List)routingPlan.vehicles()).containsExactly((Object[])new Vehicle[]{vehicle});
        Assertions.assertThat((Optional)routingPlan.depot()).contains((Object)depot);
        Assertions.assertThat((List)routingPlan.visits()).isEmpty();
        Assertions.assertThat((List)routingPlan.routes()).hasSize(1);
        RouteWithTrack routeWithTrack = (RouteWithTrack)routingPlan.routes().iterator().next();
        Assertions.assertThat((Object)routeWithTrack.depot()).isEqualTo((Object)depot);
        Assertions.assertThat((Object)routeWithTrack.vehicle()).isEqualTo((Object)vehicle);
        Assertions.assertThat((List)routeWithTrack.visits()).isEmpty();
        Assertions.assertThat((List)routeWithTrack.track()).isEmpty();
    }

    @Test
    void listener_should_pass_routing_plan_to_consumer_when_an_update_event_occurs() {
        Coordinates depotCoordinates = Coordinates.valueOf((double)0.0, (double)0.1);
        Coordinates visitCoordinates = Coordinates.valueOf((double)2.0, (double)-0.2);
        Coordinates checkpoint1 = Coordinates.valueOf((double)12.0, (double)12.0);
        Coordinates checkpoint2 = Coordinates.valueOf((double)21.0, (double)21.0);
        List<Coordinates> path1 = Arrays.asList(depotCoordinates, checkpoint1, checkpoint2, visitCoordinates);
        List<Coordinates> path2 = Arrays.asList(visitCoordinates, checkpoint2, checkpoint1, depotCoordinates);
        Mockito.when((Object)this.router.getPath(depotCoordinates, visitCoordinates)).thenReturn(path1);
        Mockito.when((Object)this.router.getPath(visitCoordinates, depotCoordinates)).thenReturn(path2);
        long vehicleId = -5L;
        Vehicle vehicle = VehicleFactory.testVehicle((long)-5L);
        Location depot = new Location(1L, depotCoordinates);
        Location visit = new Location(2L, visitCoordinates);
        Distance distance = Distance.ofMillis((long)11L);
        Mockito.when((Object)this.vehicleRepository.find(-5L)).thenReturn(Optional.of(vehicle));
        Mockito.when((Object)this.locationRepository.find(depot.id())).thenReturn(Optional.of(depot));
        Mockito.when((Object)this.locationRepository.find(visit.id())).thenReturn(Optional.of(visit));
        ShallowRoute route = new ShallowRoute(vehicle.id(), depot.id(), Collections.singletonList(visit.id()));
        RouteChangedEvent event = new RouteChangedEvent((Object)this, distance, Collections.singletonList(-5L), Long.valueOf(depot.id()), Collections.singletonList(visit.id()), Collections.singletonList(route));
        this.routeListener.onApplicationEvent(event);
        RoutingPlan routingPlan = this.verifyAndCaptureConsumedPlan();
        Assertions.assertThat((Object)routingPlan.distance()).isEqualTo((Object)distance);
        Assertions.assertThat((List)routingPlan.vehicles()).containsExactly((Object[])new Vehicle[]{vehicle});
        Assertions.assertThat((Optional)routingPlan.depot()).contains((Object)depot);
        Assertions.assertThat((List)routingPlan.visits()).containsExactly((Object[])new Location[]{visit});
        Assertions.assertThat((List)routingPlan.routes()).hasSize(1);
        RouteWithTrack routeWithTrack = (RouteWithTrack)routingPlan.routes().iterator().next();
        Assertions.assertThat((Object)routeWithTrack.vehicle()).isEqualTo((Object)vehicle);
        Assertions.assertThat((Object)routeWithTrack.depot()).isEqualTo((Object)depot);
        Assertions.assertThat((List)routeWithTrack.visits()).containsExactly((Object[])new Location[]{visit});
        Assertions.assertThat((List)routeWithTrack.track()).containsExactly((Object[])new List[]{path1, path2});
        Assertions.assertThat((Object)this.routeListener.getBestRoutingPlan()).isEqualTo((Object)routingPlan);
    }

    @Test
    void should_discard_update_gracefully_if_one_of_the_locations_no_longer_exist() {
        Vehicle vehicle = VehicleFactory.testVehicle((long)3L);
        Location depot = new Location(1L, Coordinates.valueOf((double)1.0, (double)2.0));
        Location visit = new Location(2L, Coordinates.valueOf((double)-1.0, (double)-2.0));
        Mockito.when((Object)this.vehicleRepository.find(vehicle.id())).thenReturn(Optional.of(vehicle));
        Mockito.when((Object)this.locationRepository.find(depot.id())).thenReturn(Optional.of(depot));
        Mockito.when((Object)this.locationRepository.find(visit.id())).thenReturn(Optional.empty());
        ShallowRoute route = new ShallowRoute(vehicle.id(), depot.id(), Collections.singletonList(visit.id()));
        RouteChangedEvent event = new RouteChangedEvent((Object)this, Distance.ofMillis((long)1L), Collections.singletonList(vehicle.id()), Long.valueOf(depot.id()), Collections.singletonList(visit.id()), Collections.singletonList(route));
        Assertions.assertThat((boolean)this.routeListener.getBestRoutingPlan().isEmpty()).isTrue();
        this.routeListener.onApplicationEvent(event);
        ((Router)Mockito.verify((Object)this.router, (VerificationMode)Mockito.never())).getPath((Coordinates)ArgumentMatchers.any(), (Coordinates)ArgumentMatchers.any());
        ((Event)Mockito.verify(this.routingPlanEvent, (VerificationMode)Mockito.never())).fire((Object)((RoutingPlan)ArgumentMatchers.any()));
        Assertions.assertThat((boolean)this.routeListener.getBestRoutingPlan().isEmpty()).isTrue();
    }

    @Test
    void should_discard_update_gracefully_if_one_of_the_vehicles_no_longer_exist() {
        Vehicle vehicle = VehicleFactory.testVehicle((long)3L);
        Location depot = new Location(1L, Coordinates.valueOf((double)1.0, (double)2.0));
        Location visit = new Location(2L, Coordinates.valueOf((double)-1.0, (double)-2.0));
        Mockito.when((Object)this.vehicleRepository.find(vehicle.id())).thenReturn(Optional.empty());
        Mockito.when((Object)this.locationRepository.find(depot.id())).thenReturn(Optional.of(depot));
        ShallowRoute route = new ShallowRoute(vehicle.id(), depot.id(), Collections.singletonList(visit.id()));
        RouteChangedEvent event = new RouteChangedEvent((Object)this, Distance.ofMillis((long)1L), Collections.singletonList(vehicle.id()), Long.valueOf(depot.id()), Collections.singletonList(visit.id()), Collections.singletonList(route));
        Assertions.assertThat((boolean)this.routeListener.getBestRoutingPlan().isEmpty()).isTrue();
        this.routeListener.onApplicationEvent(event);
        ((Router)Mockito.verify((Object)this.router, (VerificationMode)Mockito.never())).getPath((Coordinates)ArgumentMatchers.any(), (Coordinates)ArgumentMatchers.any());
        ((Event)Mockito.verify(this.routingPlanEvent, (VerificationMode)Mockito.never())).fire((Object)((RoutingPlan)ArgumentMatchers.any()));
        Assertions.assertThat((boolean)this.routeListener.getBestRoutingPlan().isEmpty()).isTrue();
    }

    private RoutingPlan verifyAndCaptureConsumedPlan() {
        ((Event)Mockito.verify(this.routingPlanEvent)).fire((Object)((RoutingPlan)this.routeArgumentCaptor.capture()));
        return (RoutingPlan)this.routeArgumentCaptor.getValue();
    }
}

