/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.Route;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;

class RouteTest {
    private final Vehicle vehicle = VehicleFactory.testVehicle((long)4L);
    private final Location depot = new Location(1L, Coordinates.valueOf((double)5.0, (double)5.0));
    private final Location visit1 = new Location(2L, Coordinates.valueOf((double)5.0, (double)5.0));
    private final Location visit2 = new Location(3L, Coordinates.valueOf((double)5.0, (double)5.0));

    RouteTest() {
    }

    @Test
    void constructor_args_not_null() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Route(null, this.depot, Collections.emptyList()));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Route(this.vehicle, null, Collections.emptyList()));
        Assertions.assertThatNullPointerException().isThrownBy(() -> new Route(this.vehicle, this.depot, null));
    }

    @Test
    void visits_should_not_contain_depot() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new Route(this.vehicle, this.depot, Arrays.asList(this.depot, this.visit1))).withMessageContaining(this.depot.toString());
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new Route(this.vehicle, this.depot, Arrays.asList(this.visit1, this.depot, this.visit2))).withMessageContaining(this.depot.toString());
    }

    @Test
    void no_visit_should_be_visited_twice_by_the_same_vehicle() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new Route(this.vehicle, this.depot, Arrays.asList(this.visit1, this.visit1))).withMessageContaining("(1)");
    }

    @Test
    void cannot_modify_visits_externally() {
        ArrayList<Location> visits = new ArrayList<Location>();
        visits.add(this.visit1);
        List routeVisits = new Route(this.vehicle, this.depot, visits).visits();
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(routeVisits::clear);
    }
}

