/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import org.junit.jupiter.api.Test;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.test.api.score.stream.ConstraintVerifier;
import org.optaweb.vehiclerouting.plugin.planner.VehicleRoutingConstraintProvider;
import org.optaweb.vehiclerouting.plugin.planner.domain.DistanceMap;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocation;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningLocationFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicleFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisitFactory;
import org.optaweb.vehiclerouting.plugin.planner.domain.Standstill;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;

class VehicleRoutingConstraintProviderTest {
    private final ConstraintVerifier<VehicleRoutingConstraintProvider, VehicleRoutingSolution> constraintVerifier = ConstraintVerifier.build((ConstraintProvider)new VehicleRoutingConstraintProvider(), VehicleRoutingSolution.class, (Class[])new Class[]{Standstill.class, PlanningVisit.class});

    VehicleRoutingConstraintProviderTest() {
    }

    private static DistanceMap distanceToAll(long distance) {
        return location -> distance;
    }

    private static void route(PlanningVehicle vehicle, PlanningVisit ... visits) {
        PlanningVehicle previousStandstill = vehicle;
        for (PlanningVisit visit : visits) {
            visit.setVehicle(vehicle);
            visit.setPreviousStandstill((Standstill)previousStandstill);
            previousStandstill.setNextVisit(visit);
            previousStandstill = visit;
        }
    }

    @Test
    void vehicle_capacity_penalized_1vehicle_1visit() {
        int demand = 100;
        int capacity = 5;
        PlanningVehicle vehicle = PlanningVehicleFactory.testVehicle((long)1L, (int)capacity);
        vehicle.setDepot(new PlanningDepot(PlanningLocationFactory.testLocation((long)1L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L))));
        PlanningVisit visit = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)2L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand);
        VehicleRoutingConstraintProviderTest.route(vehicle, visit);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{visit}).penalizesBy(demand - capacity);
    }

    @Test
    void vehicle_capacity_penalized_1vehicle_3visits() {
        int demand1 = 4;
        int demand2 = 3;
        int demand3 = 9;
        int capacity = 5;
        PlanningVehicle vehicle = PlanningVehicleFactory.testVehicle((long)1L, (int)capacity);
        vehicle.setDepot(new PlanningDepot(PlanningLocationFactory.testLocation((long)0L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L))));
        PlanningVisit visit1 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)1L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand1);
        PlanningVisit visit2 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)2L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand2);
        PlanningVisit visit3 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)3L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand3);
        VehicleRoutingConstraintProviderTest.route(vehicle, visit1, visit2, visit3);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{visit1, visit2, visit3}).penalizesBy(demand1 + demand2 + demand3 - capacity);
    }

    @Test
    void capacity_not_penalized_when_greater_or_equal_to_demand() {
        int demand1 = 4;
        int demand2 = 3;
        int demand3 = 9;
        int totalDemand = demand1 + demand2 + demand3;
        PlanningVehicle vehicle = PlanningVehicleFactory.testVehicle((long)1L, (int)totalDemand);
        vehicle.setDepot(new PlanningDepot(PlanningLocationFactory.testLocation((long)0L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L))));
        PlanningVisit visit1 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)1L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand1);
        PlanningVisit visit2 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)2L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand2);
        PlanningVisit visit3 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)3L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand3);
        VehicleRoutingConstraintProviderTest.route(vehicle, visit1, visit2, visit3);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{visit1, visit2, visit3}).penalizesBy(0);
        vehicle.setCapacity(totalDemand + 1);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{visit1, visit2, visit3}).penalizesBy(0);
    }

    @Test
    void vehicles_capacity_constraint_should_work_for_multiple_vehicles() {
        int demand1a = 11;
        int demand1b = 12;
        int demand1c = 14;
        int demand2a = 3000;
        int demand2b = 2500;
        int demand2c = 8000;
        int capacity1 = demand1a + demand1b + demand1c;
        int capacity2 = demand2a + demand2b + demand2c;
        PlanningDepot depot = new PlanningDepot(PlanningLocationFactory.testLocation((long)0L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)));
        PlanningVehicle vehicle1 = PlanningVehicleFactory.testVehicle((long)1L, (int)capacity1);
        vehicle1.setDepot(depot);
        PlanningVehicle vehicle2 = PlanningVehicleFactory.testVehicle((long)2L, (int)capacity2);
        vehicle2.setDepot(depot);
        PlanningVisit visit1 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)1L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand1a);
        PlanningVisit visit2 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)2L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand1b);
        PlanningVisit visit3 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)3L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand1c);
        PlanningVisit visit4 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)4L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand2a);
        PlanningVisit visit5 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)5L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand2b);
        PlanningVisit visit6 = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)6L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(0L)), (int)demand2c);
        VehicleRoutingConstraintProviderTest.route(vehicle1, visit1, visit2, visit3);
        VehicleRoutingConstraintProviderTest.route(vehicle2, visit4, visit5, visit6);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{visit1, visit2, visit3, visit4, visit5, visit6}).penalizesBy(0);
        vehicle1.setCapacity(capacity1 - 3);
        vehicle2.setCapacity(capacity2 - 7);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::vehicleCapacity).given(new Object[]{visit1, visit2, visit3, visit4, visit5, visit6}).penalizesBy(10);
    }

    @Test
    void distance_2vehicles() {
        int fromDepot1 = 1000;
        int fromDepot2 = 2000;
        PlanningDepot depot1 = new PlanningDepot(PlanningLocationFactory.testLocation((long)0L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(fromDepot1)));
        PlanningDepot depot2 = new PlanningDepot(PlanningLocationFactory.testLocation((long)0L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(fromDepot2)));
        PlanningVehicle vehicle1 = PlanningVehicleFactory.testVehicle((long)1L, (int)Integer.MAX_VALUE);
        vehicle1.setDepot(depot1);
        PlanningVehicle vehicle2 = PlanningVehicleFactory.testVehicle((long)1L, (int)Integer.MAX_VALUE);
        vehicle2.setDepot(depot2);
        int fromA = 17;
        int fromB = 11;
        int fromC = 37;
        int fromD = 123;
        int fromE = 77;
        int fromF = 99;
        PlanningVisit visitA = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)1L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(fromA)));
        PlanningVisit visitB = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)2L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(fromB)));
        PlanningVisit visitC = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)3L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(fromC)));
        PlanningVisit visitD = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)4L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(fromD)));
        PlanningVisit visitE = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)5L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(fromE)));
        PlanningVisit visitF = PlanningVisitFactory.fromLocation((PlanningLocation)PlanningLocationFactory.testLocation((long)6L, (DistanceMap)VehicleRoutingConstraintProviderTest.distanceToAll(fromF)));
        VehicleRoutingConstraintProviderTest.route(vehicle1, visitA, visitB, visitC);
        VehicleRoutingConstraintProviderTest.route(vehicle2, visitD, visitE, visitF);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceFromPreviousStandstill).given(new Object[]{vehicle1, visitA, visitB, visitC}).penalizesBy(fromDepot1 + fromA + fromB);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceFromLastVisitToDepot).given(new Object[]{vehicle1, visitA, visitB, visitC}).penalizesBy(fromC);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceFromPreviousStandstill).given(new Object[]{vehicle2, visitD, visitE, visitF}).penalizesBy(fromDepot2 + fromD + fromE);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceFromLastVisitToDepot).given(new Object[]{vehicle2, visitD, visitE, visitF}).penalizesBy(fromF);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceFromPreviousStandstill).given(new Object[]{vehicle1, vehicle2, visitA, visitB, visitC, visitD, visitE, visitF}).penalizesBy(fromDepot1 + fromDepot2 + fromA + fromB + fromD + fromE);
        this.constraintVerifier.verifyThat(VehicleRoutingConstraintProvider::distanceFromLastVisitToDepot).given(new Object[]{vehicle1, vehicle2, visitA, visitB, visitC, visitD, visitE, visitF}).penalizesBy(fromC + fromF);
        this.constraintVerifier.verifyThat().given(new Object[]{vehicle1, vehicle2, visitA, visitB, visitC, visitD, visitE, visitF}).scores((Score)HardSoftLongScore.ofSoft((long)(-(fromDepot1 + fromDepot2 + fromA + fromB + fromC + fromD + fromE + fromF))));
    }
}

