/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.planner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.domain.Distance;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningDepot;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVehicle;
import org.optaweb.vehiclerouting.plugin.planner.domain.PlanningVisit;
import org.optaweb.vehiclerouting.plugin.planner.domain.VehicleRoutingSolution;
import org.optaweb.vehiclerouting.service.route.RouteChangedEvent;
import org.optaweb.vehiclerouting.service.route.ShallowRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class RouteChangedEventPublisher {
    private static final Logger logger = LoggerFactory.getLogger(RouteChangedEventPublisher.class);
    private final Event<RouteChangedEvent> eventPublisher;

    @Inject
    RouteChangedEventPublisher(Event<RouteChangedEvent> eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    void publishSolution(VehicleRoutingSolution solution) {
        RouteChangedEvent event = RouteChangedEventPublisher.solutionToEvent(solution, this);
        logger.info("New solution with {} depots, {} vehicles, {} visits, distance: {}, score: {}", new Object[]{solution.getDepotList().size(), solution.getVehicleList().size(), solution.getVisitList().size(), event.distance(), solution.getScore()});
        logger.debug("Routes: {}", event.routes());
        this.eventPublisher.fire((Object)event);
    }

    static RouteChangedEvent solutionToEvent(VehicleRoutingSolution solution, Object source) {
        List<ShallowRoute> routes = RouteChangedEventPublisher.routes(solution);
        return new RouteChangedEvent(source, Distance.ofMillis(-solution.getScore().getSoftScore()), RouteChangedEventPublisher.vehicleIds(solution), RouteChangedEventPublisher.depotId(solution), RouteChangedEventPublisher.visitIds(solution), routes);
    }

    private static List<Long> visitIds(VehicleRoutingSolution solution) {
        return solution.getVisitList().stream().map(visit -> visit.getLocation().getId()).collect(Collectors.toList());
    }

    private static List<ShallowRoute> routes(VehicleRoutingSolution solution) {
        if (solution.getDepotList().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ShallowRoute> routes = new ArrayList<ShallowRoute>();
        for (PlanningVehicle vehicle : solution.getVehicleList()) {
            PlanningDepot depot = vehicle.getDepot();
            if (depot == null) {
                throw new IllegalArgumentException("Vehicle (id=" + vehicle.getId() + ") is not in the depot. That's not allowed");
            }
            ArrayList<Long> visits = new ArrayList<Long>();
            for (PlanningVisit visit : vehicle.getFutureVisits()) {
                if (!solution.getVisitList().contains(visit)) {
                    throw new IllegalArgumentException("Visit (" + visit + ") doesn't exist");
                }
                visits.add(visit.getLocation().getId());
            }
            routes.add(new ShallowRoute(vehicle.getId(), depot.getId(), visits));
        }
        return routes;
    }

    private static List<Long> vehicleIds(VehicleRoutingSolution solution) {
        return solution.getVehicleList().stream().map(PlanningVehicle::getId).collect(Collectors.toList());
    }

    private static Long depotId(VehicleRoutingSolution solution) {
        return solution.getDepotList().isEmpty() ? null : Long.valueOf(solution.getDepotList().get(0).getId());
    }
}

