/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.routing;

import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.util.EncodingManager;
import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.profile.UnlessBuildProfile;
import io.quarkus.arc.properties.IfBuildProperty;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.optaweb.vehiclerouting.plugin.routing.RoutingEngineException;
import org.optaweb.vehiclerouting.plugin.routing.RoutingProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
class RoutingConfig {
    private static final Logger logger = LoggerFactory.getLogger(RoutingConfig.class);
    private final Path osmDir;
    private final Path osmFile;
    private final Optional<String> osmDownloadUrl;
    private final Path graphHopperDir;
    private final Path graphDir;

    @Inject
    RoutingConfig(RoutingProperties routingProperties) {
        this.osmDir = Paths.get(routingProperties.osmDir(), new String[0]).toAbsolutePath();
        this.osmFile = this.osmDir.resolve(routingProperties.osmFile()).toAbsolutePath();
        this.osmDownloadUrl = routingProperties.osmDownloadUrl();
        this.graphHopperDir = Paths.get(routingProperties.ghDir(), new String[0]);
        String regionName = routingProperties.osmFile().replaceFirst("\\.osm\\.pbf$", "");
        this.graphDir = this.graphHopperDir.resolve(regionName).toAbsolutePath();
    }

    @UnlessBuildProfile(value="test")
    @IfBuildProperty(name="app.routing.engine", stringValue="GRAPHHOPPER", enableIfMissing=true)
    @Produces
    @DefaultBean
    GraphHopperOSM graphHopper() {
        GraphHopperOSM graphHopper = (GraphHopperOSM)new GraphHopperOSM().forServer();
        graphHopper.setGraphHopperLocation(this.graphDir.toString());
        if (this.graphDirIsNotEmpty()) {
            logger.info("Loading existing GraphHopper graph from: {}", (Object)this.graphDir);
        } else {
            if (Files.notExists(this.osmFile, new LinkOption[0])) {
                this.initDirs();
                if (!this.osmDownloadUrl.isPresent() || this.osmDownloadUrl.get().trim().isEmpty()) {
                    throw new IllegalStateException("The osmFile (" + this.osmFile + ") does not exist and no download URL was provided.\nDownload the OSM file from https://download.geofabrik.de/ first or provide an OSM file URL using the app.routing.osm-download-url property.");
                }
                RoutingConfig.downloadOsmFile(this.osmDownloadUrl.get(), this.osmFile);
            }
            logger.info("Importing OSM file: {}", (Object)this.osmFile);
            graphHopper.setOSMFile(this.osmFile.toString());
        }
        graphHopper.setEncodingManager(EncodingManager.create((String)"car"));
        graphHopper.importOrLoad();
        logger.info("GraphHopper graph loaded");
        return graphHopper;
    }

    private boolean graphDirIsNotEmpty() {
        boolean bl;
        block9: {
            if (Files.notExists(this.graphDir, new LinkOption[0])) {
                return false;
            }
            Stream<Path> graphDirFiles = Files.list(this.graphDir);
            try {
                bl = graphDirFiles.findAny().isPresent();
                if (graphDirFiles == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (graphDirFiles != null) {
                        try {
                            graphDirFiles.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RoutingEngineException("Cannot read contents of the graph directory (" + this.graphDir + ")", e);
                }
            }
            graphDirFiles.close();
        }
        return bl;
    }

    private void initDirs() {
        try {
            Files.createDirectories(this.osmDir, new FileAttribute[0]);
            Files.createDirectories(this.graphHopperDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RoutingEngineException("Can't create directory for storing OSM download", e);
        }
    }

    static void downloadOsmFile(String urlString, Path osmFile) {
        HttpURLConnection con;
        try {
            URL url = new URL(urlString);
            con = (HttpURLConnection)url.openConnection();
        }
        catch (MalformedURLException e) {
            throw new RoutingEngineException("The OSM file URL is malformed", e);
        }
        catch (IOException e) {
            throw new RoutingEngineException("The OSM file cannot be downloaded", e);
        }
        try {
            con.setRequestMethod("GET");
        }
        catch (ProtocolException e) {
            throw new IllegalStateException("Can't set request method", e);
        }
        con.setConnectTimeout(10000);
        con.setReadTimeout(10000);
        logger.info("Downloading OSM file from {}", (Object)urlString);
        try {
            Files.copy(con.getInputStream(), osmFile, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RoutingEngineException("OSM file download failed", e);
        }
        logger.info("File saved to {}", (Object)osmFile);
    }
}

