/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.service.location;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.service.distance.DistanceRepository;
import org.optaweb.vehiclerouting.service.error.ErrorEvent;
import org.optaweb.vehiclerouting.service.location.DistanceMatrix;
import org.optaweb.vehiclerouting.service.location.DistanceMatrixRow;
import org.optaweb.vehiclerouting.service.location.LocationPlanner;
import org.optaweb.vehiclerouting.service.location.LocationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class LocationService {
    private static final Logger logger = LoggerFactory.getLogger(LocationService.class);
    private final LocationRepository repository;
    private final DistanceRepository distanceRepository;
    private final LocationPlanner planner;
    private final DistanceMatrix distanceMatrix;
    private final Event<ErrorEvent> errorEvent;

    @Inject
    LocationService(LocationRepository repository, DistanceRepository distanceRepository, LocationPlanner planner, DistanceMatrix distanceMatrix, Event<ErrorEvent> errorEvent) {
        this.repository = repository;
        this.distanceRepository = distanceRepository;
        this.planner = planner;
        this.distanceMatrix = distanceMatrix;
        this.errorEvent = errorEvent;
    }

    public synchronized void addLocation(Location location) {
        Objects.requireNonNull(location);
        DistanceMatrixRow distanceMatrixRow = this.distanceMatrix.addLocation(location);
        this.planner.addLocation(location, distanceMatrixRow);
    }

    @Transactional
    public synchronized Optional<Location> createLocation(Coordinates coordinates, String description) {
        Objects.requireNonNull(coordinates);
        Objects.requireNonNull(description);
        Location location = this.repository.createLocation(coordinates, description);
        Optional<DistanceMatrixRow> distanceMatrixRow = this.addToMatrix(location);
        if (distanceMatrixRow.isPresent()) {
            this.planner.addLocation(location, distanceMatrixRow.get());
            return Optional.of(location);
        }
        this.repository.removeLocation(location.id());
        return Optional.empty();
    }

    private Optional<DistanceMatrixRow> addToMatrix(Location location) {
        try {
            DistanceMatrixRow distanceMatrixRow = this.distanceMatrix.addLocation(location);
            this.repository.locations().stream().filter(existingLocation -> !existingLocation.equals(location)).forEach(existingLocation -> {
                this.distanceRepository.saveDistance(location, (Location)existingLocation, distanceMatrixRow.distanceTo(existingLocation.id()));
                this.distanceRepository.saveDistance((Location)existingLocation, location, this.distanceMatrix.distance((Location)existingLocation, location));
            });
            return Optional.of(distanceMatrixRow);
        }
        catch (Exception e) {
            logger.error("Failed to calculate distances for location {}, it will be discarded", (Object)location.fullDescription(), (Object)e);
            this.errorEvent.fire((Object)new ErrorEvent(this, "Failed to calculate distances for location " + location.fullDescription() + ", it will be discarded.\n" + e.toString()));
            return Optional.empty();
        }
    }

    @Transactional
    public synchronized void removeLocation(long id) {
        Location depot;
        Optional<Location> optionalLocation = this.repository.find(id);
        if (!optionalLocation.isPresent()) {
            this.errorEvent.fire((Object)new ErrorEvent(this, "Location [" + id + "] cannot be removed because it doesn't exist."));
            return;
        }
        Location removedLocation = optionalLocation.get();
        List<Location> locations = this.repository.locations();
        if (locations.size() > 1 && removedLocation.equals(depot = locations.stream().min(Comparator.comparingLong(Location::id)).orElseThrow(() -> new IllegalStateException("Impossible. Locations have size (" + locations.size() + ") but the stream is empty.")))) {
            this.errorEvent.fire((Object)new ErrorEvent(this, "You can only remove depot if there are no visits."));
            return;
        }
        this.planner.removeLocation(removedLocation);
        this.repository.removeLocation(id);
        this.distanceMatrix.removeLocation(removedLocation);
        this.distanceRepository.deleteDistances(removedLocation);
    }

    @Transactional
    public synchronized void removeAll() {
        this.planner.removeAllLocations();
        this.repository.removeAll();
        this.distanceMatrix.clear();
        this.distanceRepository.deleteAll();
    }

    public void populateDistanceMatrix() {
        this.repository.locations().forEach(from -> this.repository.locations().stream().filter(to -> !to.equals(from)).forEach(to -> this.distanceMatrix.put((Location)from, (Location)to, this.distanceRepository.getDistance((Location)from, (Location)to).orElseThrow(() -> new IllegalStateException("Distance from: [" + from + "] to: [" + to + "] is missing in the distance repository. This should not happen.")))));
    }
}

