/*
 * Decompiled with CFR 0.152.
 */
package org.optaweb.vehiclerouting.plugin.rest;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.optaweb.vehiclerouting.domain.Coordinates;
import org.optaweb.vehiclerouting.domain.Location;
import org.optaweb.vehiclerouting.domain.LocationData;
import org.optaweb.vehiclerouting.domain.RoutingProblem;
import org.optaweb.vehiclerouting.domain.Vehicle;
import org.optaweb.vehiclerouting.domain.VehicleFactory;
import org.optaweb.vehiclerouting.plugin.rest.ServerInfoResource;
import org.optaweb.vehiclerouting.plugin.rest.model.PortableCoordinates;
import org.optaweb.vehiclerouting.plugin.rest.model.RoutingProblemInfo;
import org.optaweb.vehiclerouting.plugin.rest.model.ServerInfo;
import org.optaweb.vehiclerouting.service.demo.DemoService;
import org.optaweb.vehiclerouting.service.region.BoundingBox;
import org.optaweb.vehiclerouting.service.region.RegionService;

@ExtendWith(value={MockitoExtension.class})
class ServerInfoResourceTest {
    @Mock
    private RegionService regionService;
    @Mock
    private DemoService demoService;
    @InjectMocks
    private ServerInfoResource serverInfoResource;

    ServerInfoResourceTest() {
    }

    @Test
    void serverInfo() {
        List<String> countryCodes = Arrays.asList("XY", "WZ");
        Mockito.when((Object)this.regionService.countryCodes()).thenReturn(countryCodes);
        Coordinates southWest = Coordinates.of((double)-1.0, (double)-2.0);
        Coordinates northEast = Coordinates.of((double)1.0, (double)2.0);
        BoundingBox boundingBox = new BoundingBox(southWest, northEast);
        Mockito.when((Object)this.regionService.boundingBox()).thenReturn((Object)boundingBox);
        Location depot = new Location(1L, Coordinates.of((double)1.0, (double)7.0), "Depot");
        List<Location> visits = Arrays.asList(new Location(2L, Coordinates.of((double)2.0, (double)9.0), "Visit"));
        List<Vehicle> vehicles = Arrays.asList(VehicleFactory.testVehicle((long)1L));
        String demoName = "Testing problem";
        RoutingProblem routingProblem = new RoutingProblem(demoName, vehicles, (LocationData)depot, visits);
        Mockito.when((Object)this.demoService.demos()).thenReturn(Arrays.asList(routingProblem));
        ServerInfo serverInfo = this.serverInfoResource.serverInfo();
        Assertions.assertThat((List)serverInfo.getCountryCodes()).isEqualTo(countryCodes);
        Assertions.assertThat((List)serverInfo.getBoundingBox()).containsExactly((Object[])new PortableCoordinates[]{PortableCoordinates.fromCoordinates((Coordinates)southWest), PortableCoordinates.fromCoordinates((Coordinates)northEast)});
        List demos = serverInfo.getDemos();
        Assertions.assertThat((List)demos).hasSize(1);
        RoutingProblemInfo demo = (RoutingProblemInfo)demos.get(0);
        Assertions.assertThat((String)demo.getName()).isEqualTo(demoName);
        Assertions.assertThat((int)demo.getVisits()).isEqualTo(visits.size());
    }
}

